import React from 'react';
import { Button, Image } from 'antd';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { contractStatusList } from '~/utils/dictionary';
import { FddInterfaceAPI } from '~/api';
import { decode } from 'js-base64';
import FileSaver from 'file-saver';
import './index.scss';

// 接口返回的类型
type DataType = InterDataType<mallOrderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType | undefined;
};

const DetailPurchaser: React.FC<PropsType> = ({ detail }) => {
  //   合同预览
  const contractPreview = () => {
    if (detail?.contractInfoDTO?.contractNo) {
      FddInterfaceAPI.viewContract({ contractId: detail?.contractInfoDTO?.contractNo }).then(
        ({ result }) => {
          window.open(decode(result), '_blank');
        },
      );
    }
  };
  // 合同下载
  const downloadContract = () => {
    if (detail?.contractInfoDTO?.contractNo) {
      FddInterfaceAPI.downloadContract({ contractId: detail?.contractInfoDTO?.contractNo }).then(
        ({ result }) => {
          FileSaver.saveAs(decode(result), `${detail?.contractInfoDTO?.contractNo}.pdf`);
        },
      );
    }
  };

  return (
    <div className='detail-purchaser detail-half'>
      <div className='detail-title'>买家信息</div>
      <div className='detail-text'>UID：{detail?.userAccountId}</div>
      <div className='detail-text'>姓名： {detail?.userName || detail?.nickname}</div>
      <div className='detail-text'>手机号：{detail?.phoneNum} </div>
      <div className='detail-text remark'>
        <div className='label'>备注：</div>
        <div className='value'>{detail?.userRemark}</div>
      </div>
      {detail?.contractInfoDTO ? (
        <div>
          <div className='detail-title'>合同信息</div>
          <div className='detail-text'>合同编号： {detail.contractInfoDTO.contractNo}</div>
          <div className='detail-text'>合同标题： {detail.contractInfoDTO.contractTitle}</div>
          <div className='detail-text'>
            合同状态：
            <span style={{ color: 'red' }}>
              {
                contractStatusList.find((v) => v.value === detail.contractInfoDTO?.signStatus)
                  ?.label
              }
            </span>
          </div>
          <div className='detail-text'>
            合同操作：
            <Button type='link' onClick={contractPreview}>
              查看
            </Button>
            <Button type='link' onClick={downloadContract}>
              下载
            </Button>
          </div>
        </div>
      ) : (
        ''
      )}
      {detail?.payDTOList ? (
        <>
          <div className='detail-title'>付款凭证</div>
          {detail?.payDTOList.map((v, index) => (
            <div key={index} className='pay-img-wrap'>
              <div className='detail-text'>
                第{index + 1}次上传
                <span style={{ color: 'red' }}>
                  ({v.checkStatus === 0 ? '待审批' : v.checkStatus === 1 ? '已通过' : '未通过'})
                </span>
                ：
              </div>
              <div className='detail-image'>
                {JSON.parse(v.payImgList).map((i: any, j: number) => (
                  <Image key={j} className='image' src={i.filePath} alt='付款凭证' />
                ))}
              </div>
            </div>
          ))}

          <div className='detail-text remark'>
            <div className='label'>凭证备注：</div>
            <div className='value'>{detail?.payDTOList[0].payRemark}</div>
          </div>
        </>
      ) : (
        ''
      )}
    </div>
  );
};

export default DetailPurchaser;
