import { FC, useState } from 'react';
import {
  Form,
  Modal,
  ModalProps,
  Radio,
  Image,
  Row,
  Col,
  Input,
  RadioChangeEvent,
  message,
} from 'antd';
import './index.scss';
import { OrderManageAPI } from '~/api';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
  mallOrderItem: any;
  type: number; //0:采购订单，1：商城订单
}
// 订单对象类型
// type mallOrderItemType = InterListType<mallOrderListType>[0];

const ApprovalOrder: FC<ModalProps & selfProps> = ({
  open,
  onCancel,
  onOk,
  mallOrderItem,
  type,
}) => {
  const [form] = Form.useForm<{ checkStatus: number; refuseReason: string }>();
  const [checkStatus, setCheckStatus] = useState<number>(1);
  const radioChange = (e: RadioChangeEvent) => {
    setCheckStatus(e.target.value);
  };
  // 获取需要审批的凭证
  const getApproveObj = () => {
    return type === 1
      ? mallOrderItem?.payDTOList?.find((v: any) => v.checkStatus === 0)
      : mallOrderItem?.payDTOS?.find((v: any) => v.checkStatus === 0);
  };

  const handleOk = () => {
    if (mallOrderItem) {
      form.validateFields().then((values) => {
        OrderManageAPI[type === 1 ? 'approvalOrder' : 'uavPoCheckPay']({
          uavOrderId: mallOrderItem?.id,
          checkStatus: values.checkStatus,
          refuseReason: values.refuseReason || undefined,
          id: getApproveObj()?.id || 0,
        }).then(({ code }) => {
          if (code === '200') {
            message.success('审批成功');
            form.resetFields();
            onOk();
          }
        });
      });
    }
  };
  const handleCancel = () => {
    form.resetFields();
    onCancel();
  };
  return (
    <Modal open={open} title='凭证审批' onOk={handleOk} onCancel={handleCancel}>
      <Form
        labelCol={{ span: 2 }}
        wrapperCol={{ span: 19 }}
        initialValues={{ checkStatus: 1 }}
        form={form}
      >
        <Form.Item label='状态' name='checkStatus'>
          <Radio.Group onChange={radioChange}>
            <Radio value={1}>通过</Radio>
            <Radio value={2}>驳回</Radio>
          </Radio.Group>
        </Form.Item>
        {checkStatus === 2 ? (
          <Form.Item name='refuseReason' label='原因'>
            <Input.TextArea placeholder='请输入驳回原因' rows={4} showCount maxLength={70} />
          </Form.Item>
        ) : (
          ''
        )}
      </Form>
      {
        <Row>
          <Col span={2}>凭证：</Col>
          <Col span={19}>
            <div className='pay-img-wrap'>
              {JSON.parse(getApproveObj()?.payImgList || '[]').map((i: any, j: number) => (
                <Image src={i.filePath} key={j} width={100} height={100} />
              ))}
            </div>
          </Col>
        </Row>
      }
    </Modal>
  );
};
export default ApprovalOrder;
