import React, { useEffect } from 'react';
import { Button, Image } from 'antd';
import { orderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<orderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType;
};

const DetailPurchaser: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 物流列表
  const [expressList, setExpressList] = React.useState<{ label: string; value: string }[]>([]);
  // 获取物流信息
  const getListExpressInfo = async () => {
    const res = await OrderManageAPI.listExpressInfo({});
    if (res && res.code === '200') {
      setExpressList(res.result.map((item) => ({ label: item.exName, value: item.exCode })));
      // console.log(res);
    }
  };
  // 转换物流信息
  const getExpressInfo = (code: string | undefined | null) => {
    return expressList.find((item) => item.value === code)?.label || code;
  };
  // componentDidMount
  useEffect(() => {
    getListExpressInfo().then();
  }, []);
  return (
    <div className={'detail-purchaser detail-half'}>
      <div className={'detail-title'}>买家信息</div>
      <div className={'detail-text'}>UID：{detail?.uid}</div>
      <div className={'detail-text'}>姓名： {detail?.buyerName}</div>
      <div className={'detail-text'}>手机号： {detail?.buyerPhone}</div>
      {/*<div className={'detail-text'}>企业： 浙江科比特创新科技有限公司</div>*/}
      <div className={'detail-text'}>备注： {detail?.remark}</div>

      <div style={{ display: 'none' }}>
        <div className={'detail-title'}>合同信息</div>
        <div className={'detail-text'}>合同编号： UAV202334741131</div>
        <div className={'detail-text'}>合同状态： 已归档</div>
        <div className={'detail-text'}>
          合同操作：
          <Button type={'link'}>平台签署</Button>
          <Button type={'link'}>查看</Button>
          <Button type={'link'}>下载</Button>
        </div>
      </div>

      <div style={{ display: 'none' }}>
        <div className={'detail-title'}>付款凭证</div>
        <div className={'detail-text'}>预付款：</div>
        <div className={'detail-image'}>
          {[
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          ].map((i, j) => (
            <Image key={j} className={'image'} src={i} alt='付款凭证' />
          ))}
        </div>
        <div className={'detail-text'}>尾款：</div>
        <div className={'detail-image'}>
          {[
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          ].map((i, j) => (
            <Image key={j} className={'image'} src={i} alt='付款凭证' />
          ))}
        </div>
        <div className={'detail-text'}>全款：</div>
        <div className={'detail-image'}>
          {[
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
            'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          ].map((i, j) => (
            <Image key={j} className={'image'} src={i} alt='付款凭证' />
          ))}
        </div>
      </div>

      <div className={'detail-title'}>发货信息</div>
      <div className={'detail-text'}>收货人：{detail?.receipt?.takeName}</div>
      <div className={'detail-text'}>手机号：{detail?.receipt?.takePhone}</div>
      <div className={'detail-text'}>收货地址：{detail?.receipt?.detailAddress}</div>
      <div className={'detail-text'}>物流单号：{detail?.receipt?.sendExNo}</div>
      <div className={'detail-text'}>物流公司：{getExpressInfo(detail?.receipt?.sendExCode)}</div>
      <div className={'detail-text'}>
        物流进度：-- <Button type={'link'}>查看详情</Button>
      </div>

      <div className={'detail-title'}>归还信息</div>
      <div className={'detail-text'}>收货人：{detail?.receipt?.renName}</div>
      <div className={'detail-text'}>手机号：{detail?.receipt?.renPhone}</div>
      <div className={'detail-text'}>收货地址：{detail?.receipt?.renAddress}</div>
      <div className={'detail-text'}>物流单号：{detail?.receipt?.renExNo}</div>
      <div className={'detail-text'}>物流公司：{getExpressInfo(detail?.receipt?.renExCode)}</div>
      <div className={'detail-text'}>
        物流进度：-- <Button type={'link'}>查看详情</Button>
      </div>
    </div>
  );
};

export default DetailPurchaser;
