import SearchBox, { searchColumns as searchColumnsType } from '~/components/search-box';
import { Button, Card, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { useState } from 'react';
import { ColumnsType } from 'antd/es/table';

const RentList = () => {
  const searchColumns: searchColumnsType[] = [
    {
      label: '商品名称',
      name: '',
      type: 'input',
      placeholder: '请输入商品名称',
    },
    {
      label: '商品类型',
      name: '',
      type: 'select',
      placeholder: '请选择商品类型',
      options: [],
    },
    {
      label: '商品品牌',
      name: '',
      type: 'select',
      placeholder: '请选择商品品牌',
      options: [],
    },
  ];
  const tabList = [
    {
      key: '1',
      tab: '全部',
    },
    {
      key: '2',
      tab: '上架中',
    },
    {
      key: '3',
      tab: '仓库中',
    },
  ];
  const [activeTabKey, setActiveTabKey] = useState<string>('1');
  const tableColumns: ColumnsType<any> = [
    {
      title: '商品名称',
      align: 'center',
    },
    {
      title: '押金范围',
      align: 'center',
    },
    {
      title: '租金范围（日）',
      align: 'center',
    },
    {
      title: '库存',
      align: 'center',
    },
    {
      title: '销量',
      align: 'center',
    },
    {
      title: '创建时间',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
    },
  ];
  const [tableData, setTableData] = useState<any>([{ id: 1 }]);

  const onTabChange = (key: string) => {
    setActiveTabKey(key);
  };

  return (
    <div className='rent-list'>
      <SearchBox
        search={searchColumns}
        child={
          <Button icon={<PlusOutlined />} type='primary'>
            新增商品
          </Button>
        }
      />
      <Card tabList={tabList} activeTabKey={activeTabKey} onTabChange={onTabChange}>
        <Table bordered columns={tableColumns} rowKey='id' dataSource={tableData} />
      </Card>
    </div>
  );
};
export default RentList;
