import React from 'react';
import { RouteObject } from 'react-router-dom';
import ErrorPage from '~/pages/common/error';
import LayoutView from '~/components/layout';
import {
  MacCommandOutlined,
  ShoppingOutlined,
  ShopOutlined,
  CreditCardOutlined,
  SmileOutlined,
  TeamOutlined,
  SolutionOutlined,
  SettingOutlined,
  UserOutlined,
  AppstoreAddOutlined,
  AppstoreOutlined,
  CoffeeOutlined,
  BookOutlined,
  SketchOutlined,
  DribbbleOutlined,
  MessageOutlined,
  AliwangwangOutlined,
  AuditOutlined,
  MonitorOutlined,
  PictureOutlined,
  PaperClipOutlined,
  ReadOutlined,
  ThunderboltOutlined,
  BankOutlined,
  VerifiedOutlined,
  AccountBookOutlined,
  EnvironmentOutlined,
  BarChartOutlined,
  FireOutlined,
  InsertRowAboveOutlined,
  WechatOutlined,
  UsergroupAddOutlined,
  ContactsOutlined,
  CommentOutlined,
} from '@ant-design/icons';
import { Spin } from 'antd';

// 数据看板
const DataBoardView = React.lazy(() => import('~/pages/dataDashboards'));
// 登录
import LoginView from '~/pages/common/login';

// 积分
import { PointList } from '~/pages/pointManage/pointList';
import { PointDetail } from '~/pages/pointManage/pointList/detail';
// import { PointRules } from '~/pages/pointManage/pointRules';
// import PointDetailList from '~/pages/pointManage/pointDetail';
// 分成
// import DivideOrder from '~/pages/pointManage/divideOrder';
// import DivideRules from '~/pages/pointManage/divideRules';
// 活动
// const ActivityList = React.lazy(() => import('src/pages/activityManage/activityList')); //活动管理
// 客户管理
import CustomListView from '~/pages/customManage/customList';
// import CustomMoneyView from '~/pages/customManage/customMoney';
// import CustomMoneyDetail from '~/pages/customManage/customMoney/detail';
const CustomVerificationView = React.lazy(
  () => import('~/pages/customManage/customVerification/list'),
); //实名认证
const CustomVerificationDetailView = React.lazy(
  () => import('~/pages/customManage/customVerification/details'),
);

// 消耗管理
const WithDrawListView = React.lazy(() => import('src/pages/depleteManage/withDrawList')); //提现列表

//资源管理
import MaterielManageView from '~/pages/resourceManage/materielManage';
import MaterielManageDetail from '~/pages/resourceManage/materielManage/detail';
const GatheringListView = React.lazy(
  () => import('~/pages/resourceManage/requirementsGathering/gatherList'),
); //需求收集列表
const GatherDetailView = React.lazy(
  () => import('~/pages/resourceManage/requirementsGathering/gatherDetail'),
);

const TagManageView = React.lazy(() => import('~/pages/resourceManage/tagManage')); //标签管理
const IndustryNewsView = React.lazy(() => import('~/pages/resourceManage/industryNews'));
//论坛管理
const DynamicListView = React.lazy(() => import('~/pages/forumManage/dynamicList'));
const TopicListView = React.lazy(() => import('~/pages/forumManage/topicList'));
// 订单
const ProductOrderView = React.lazy(() => import('src/pages/orderManage/productOrder/orderList')); //销售订单
const EquipmentOrderView = React.lazy(() => import('src/pages/orderManage/equipmentOrder')); //设备订单
// const ServiceOrderView = React.lazy(() => import('src/pages/orderManage/serviceOrder')); //服务订单
const ProductOrderDetail = React.lazy(() => import('~/pages/orderManage/productOrder/orderDetail'));
// const ServiceOrderDetail = React.lazy(() => import('~/pages/orderManage/serviceOrder/detail'));
const EquipmentOrderDetail = React.lazy(() => import('~/pages/orderManage/equipmentOrder/detail'));
const PilotTrainingOrderView = React.lazy(() => import('~/pages/orderManage/pilotTrainingOrder'));
const DemandOrderListView = React.lazy(() => import('~/pages/orderManage/demandOrder/orderList')); //需求订单
const DemandOrderDetailView = React.lazy(
  () => import('~/pages/orderManage/demandOrder/orderDetail'),
); //需求订单详情
const ProcurementOrder = React.lazy(() => import('~/pages/orderManage/procurementOrder/orderList')); //商城采购订单列表
const ProcurementOrderDetail = React.lazy(
  () => import('~/pages/orderManage/procurementOrder/orderDetail'),
); //商城采购订单详情

//商品管理
import CourseManageView from '~/pages/pilotTraining/courseManage'; //课程管理
const ServiceListView = React.lazy(() => import('~/pages/mallManage/serviceManage/serviceList')); //服务列表
const ServiceDetailView = React.lazy(
  () => import('~/pages/mallManage/serviceManage/serviceDetail'),
); //服务详情
// const ServiceIntroduceView = React.lazy(
//   () => import('~/pages/mallManage/serviceManageOld/serviceIntroduce'),
// ); //服务介绍

const RentListView = React.lazy(() => import('~/pages/rentManage/rentGoods/rentList')); //租赁列表
const RentAddOrEditView = React.lazy(() => import('~/pages/rentManage/rentGoods/rentAddOrEdit')); //租赁新增、编辑
const RentDetailView = React.lazy(() => import('~/pages/rentManage/rentGoods/rentDetail')); //租赁详情
const RentTypeView = React.lazy(() => import('~/pages/rentManage/rentType')); //租赁-类型管理
const RentMakeView = React.lazy(() => import('~/pages/rentManage/rentMake')); //租赁-品牌管理
const RentModeView = React.lazy(() => import('~/pages/rentManage/rentMode')); //租赁-型号管理

const MallGoodsView = React.lazy(() => import('~/pages/mallManage/mallGoods/goodsList')); //商城商品
const MallAddOrEditOrDetailView = React.lazy(
  () => import('~/pages/mallManage/mallGoods/goodsAddOrEditOrDetail'),
); //商城商品新增、编辑
const MallGoodsDetailsView = React.lazy(() => import('~/pages/mallManage/mallGoods/goodsDetails')); //商城商品（新）

// const ProduceListView = React.lazy(() => import('~/pages/mallManage/produceManage/produceList')); //产品列表
// const ProduceDetailView = React.lazy(() => import('~/pages/mallManage/produceManage/produceDetail')); //产品详情
// const MakeListView = React.lazy(() => import('~/pages/mallManage/makeManage/makeList'));
// 分类管理
const MallCategoryListView = React.lazy(() => import('~/pages/categoryManage/mallCategoryList')); //商城分类
const ServiceCategoryListView = React.lazy(
  () => import('~/pages/categoryManage/serviceCategoryList'),
); //服务分类
// const CategoryManage = React.lazy(() => import('~/pages/categoryManage/category'));
// const CategoryDetail = React.lazy(() => import('~/pages/categoryManage/category/detail'));
// 目录管理
// const DirectoryManage = React.lazy(() => import('~/pages/categoryManage/directoryManage'));

//执照培训
const InstitutionsListView = React.lazy(
  () => import('~/pages/pilotTraining/licenseExamination/institutionsList'),
); //机构列表
const AddInstitutionsView = React.lazy(
  () => import('~/pages/pilotTraining/licenseExamination/addOrEditInstitution'),
); //机构上传

//飞手中心
const FlyerListView = React.lazy(() => import('src/pages/flyerManage/flyerList')); //飞手列表
const FlyerAuthDailyView = React.lazy(() => import('~/pages/flyerManage/flyerAuthDaily')); //飞手认证日志;
const FlyerDetailsView = React.lazy(() => import('src/pages/flyerManage/flyerDetail')); //飞手详情、飞手审批

// 系统管理
import AccountManageView from '~/pages/systemManage/accountManage';
import TenderManageView from '~/pages/resourceManage/tenderManage';
import TenderManageDetail from '~/pages/resourceManage/tenderManage/detail';
import TenderManageFeedback from '~/pages/resourceManage/tenderManage/feedback';
import BusinessCaseManage from '~/pages/resourceManage/businessCaseManage';
import CustomIdentityView from '~/pages/customManage/customIdentity';
import CompanyListView from '~/pages/systemManage/companyManage/companyList'; //单位列表
const CompanyDetailView = React.lazy(
  () => import('~/pages/systemManage/companyManage/companyDetail'),
);
import AccountLimit from '~/pages/systemManage/limitManage/roleList'; //账号权限
import LimitInfo from '~/pages/systemManage/limitManage/limitInfo';
import CustomListDetail from '~/pages/customManage/customList/detail';
import ServiceCategoryDetail from '~/pages/categoryManage/serviceCategoryList/detail';
import RewardsManageView from '~/pages/activityManage/rewardsManage';
import ActivityListView from '~/pages/activityManage/activityList';
import ActivityListDetailView from '~/pages/activityManage/activityList/detail';
import FlyerTeamView from '~/pages/flyerManage/flyerTeam';
import CompanyMemberView from '~/pages/systemManage/companyManage/companyMember';
import CourseCategoryView from '~/pages/pilotTraining/courseCategory';
import NoticeManageView from '~/pages/resourceManage/noticeManage';
const AddressManageView = React.lazy(() => import('~/pages/systemManage/addressManage'));

// const IndustryListView = React.lazy(() => import('~/pages/mallManage/industryManage/industryList')); //行业列表
// const IndustryDetailView = React.lazy(
//   () => import('~/pages/mallManage/industryManage/industryDetail'),
// ); //行业详情

// 优惠券
// const CouponList = React.lazy(() => import('src/pages/couponManage/couponList')); //优惠券管理
// const CouponDetail = React.lazy(() => import('src/pages/couponManage/couponList/detail')); //优惠券明细
// const SplitCouponList = React.lazy(() => import('src/pages/couponManage/splitCouponList')); //裂变优惠券
// const SplitCouponOperate = React.lazy(
//   () => import('src/pages/couponManage/splitCouponList/addOrEditOrDetail'),
// ); // 裂变优惠券操作
// const CouponDetailed = React.lazy(() => import('src/pages/couponManage/couponDetailed')); //优惠券明细

export interface RouteObjectType {
  path: string;
  element: any;
  errorElement?: React.ReactNode | null;
  children?: Array<RouteObject & RouteObjectType>;
  meta: {
    id: number;
    hidden?: boolean;
    icon: any;
    customIcon?: boolean;
    title: string;
    develop?: boolean;
    pid?: number;
  };
}
// 加载页面
const withLoadingComponent = (comp: JSX.Element) => (
  <React.Suspense
    fallback={
      <Spin size='large' tip='Loading...'>
        <div style={{ width: '100%', height: '50vh', marginTop: '10vh' }}></div>
      </Spin>
    }
  >
    {comp}
  </React.Suspense>
);

// 路由白名单
export const whiteRouterList: Array<RouteObject & RouteObjectType> = [
  {
    path: '/login',
    element: withLoadingComponent(<LoginView />),
    meta: {
      id: 0,
      title: '登录',
      icon: MacCommandOutlined,
    },
    errorElement: <ErrorPage />,
  },
];

// 路由数组
export const routerList: Array<RouteObjectType> = [
  {
    path: '/dataDashboards',
    element: withLoadingComponent(<DataBoardView />),
    errorElement: <ErrorPage />,
    meta: {
      icon: <BarChartOutlined />,
      title: '数据看板',
      id: 100,
    },
  },
  {
    path: '/customManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 200,
      icon: <TeamOutlined />,
      title: '用户管理',
    },
    children: [
      {
        path: '/customManage/customList',
        element: withLoadingComponent(<CustomListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 210,
          title: '用户列表',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customVerification',
        element: withLoadingComponent(<CustomVerificationView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 220,
          title: '实名认证',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/customVerificationDetail',
        element: withLoadingComponent(<CustomVerificationDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 250,
          title: '实名认证详情',
          hidden: true,
          icon: <SolutionOutlined />,
          pid: 260,
        },
      },
      {
        path: '/customManage/customList/detail',
        element: withLoadingComponent(<CustomListDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 220,
          title: '邀请列表',
          icon: <SolutionOutlined />,
          hidden: true,
          pid: 200,
        },
      },
      {
        path: '/customManage/flyerList',
        element: withLoadingComponent(<FlyerListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 230,
          title: '飞手列表',
          icon: <SolutionOutlined />,
        },
      },
      {
        path: '/customManage/flyerAuthDaily',
        element: withLoadingComponent(<FlyerAuthDailyView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 235,
          title: '认证日志',
          hidden: true,
          icon: <UserOutlined />,
          pid: 230,
        },
      },
      {
        path: '/customManage/flyerDetail',
        element: withLoadingComponent(<FlyerDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 236,
          title: '飞手详情',
          hidden: true,
          icon: <UserOutlined />,
          pid: 230,
        },
      },
      {
        path: '/customManage/flyerApprove',
        element: withLoadingComponent(<FlyerDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 237,
          title: '飞手审批',
          hidden: true,
          icon: <UserOutlined />,
          pid: 230,
        },
      },
      {
        path: '/customManage/customIdentity',
        element: withLoadingComponent(<CustomIdentityView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 240,
          title: '商家管理',
          icon: <AuditOutlined />,
        },
      },
      // {
      //   path: '/customManage/customMoney',
      //   element: withLoadingComponent(<CustomMoneyView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 26200,
      //     title: '现金管理',
      //     icon: <RedEnvelopeOutlined />,
      //     hidden: true,
      //   },
      // },
      // {
      //   path: '/customManage/customMoney/detail',
      //   element: withLoadingComponent(<CustomMoneyDetail />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 26210,
      //     title: '现金变更',
      //     icon: <RedEnvelopeOutlined />,
      //     hidden: true,
      //     pid: 26200,
      //   },
      // },
    ],
  },
  {
    path: '/flyerManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 300,
      icon: <ContactsOutlined />,
      title: '飞手管理',
      // develop: true,
    },
    children: [
      {
        path: '/flyerManage/flyerTeam',
        element: withLoadingComponent(<FlyerTeamView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 310,
          title: '飞手团队',
          icon: <UsergroupAddOutlined />,
          // develop: true,
        },
      },
    ],
  },
  {
    path: '/mallManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 400,
      icon: <ShopOutlined />,
      title: '产品商城',
    },
    children: [
      //  产品商城分类（新）
      {
        path: '/mallManage/mallCategoryList',
        element: withLoadingComponent(<MallCategoryListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 420,
          title: '商城分类',
          icon: <AppstoreOutlined />,
        },
      },
      {
        path: '/mallManage/mallCategoryList/detail',
        element: withLoadingComponent(<ServiceCategoryDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 425,
          title: '分类详情',
          icon: '',
          hidden: true,
          pid: 420,
        },
      },
      {
        path: '/mallManage/mallGoods',
        element: withLoadingComponent(<MallGoodsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 410,
          icon: <ShopOutlined />,
          title: '商城商品',
        },
      },
      {
        path: '/mallManage/mallGoods/add',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 415,
          icon: <SmileOutlined />,
          title: '商城商品新增',
          hidden: true,
          pid: 410,
        },
      },
      {
        path: '/mallManage/mallGoods/edit',
        element: withLoadingComponent(<MallAddOrEditOrDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 415,
          icon: <SmileOutlined />,
          title: '商城商品编辑',
          hidden: true,
          pid: 410,
        },
      },
      {
        path: '/mallManage/mallGoods/detail',
        element: withLoadingComponent(<MallGoodsDetailsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 415,
          icon: <SmileOutlined />,
          title: '商城商品详情',
          hidden: true,
          pid: 410,
        },
      },
      {
        path: '/mallManage/productOrder',
        element: withLoadingComponent(<ProductOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 430,
          title: '商城订单',
          icon: <ShoppingOutlined />,
        },
      },
      {
        path: '/mallManage/productOrder/detail',
        element: withLoadingComponent(<ProductOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 431,
          title: '商城订单 / 详情',
          icon: <ShoppingOutlined />,
          hidden: true,
          pid: 430,
        },
      },
      {
        path: '/mallManage/procurementOrder/list',
        element: withLoadingComponent(<ProcurementOrder />),
        errorElement: <ErrorPage />,
        meta: {
          id: 440,
          title: '采购订单',
          icon: <ShoppingOutlined />,
        },
      },
      {
        path: '/mallManage/procurementOrder/detail',
        element: withLoadingComponent(<ProcurementOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 441,
          title: '采购订单详情',
          icon: <ShoppingOutlined />,
          hidden: true,
          pid: 440,
        },
      },
    ],
  },
  {
    path: '/rentManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 500,
      icon: <ShopOutlined />,
      title: '租赁管理',
    },
    children: [
      {
        path: '/rentManage/rentType',
        element: withLoadingComponent(<RentTypeView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 520,
          icon: <ShopOutlined />,
          title: '租赁分类',
        },
      },
      {
        path: '/rentManage/rentGoods',
        element: withLoadingComponent(<RentListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 510,
          icon: <SmileOutlined />,
          title: '租赁商品',
        },
      },
      {
        path: '/rentManage/rentGoods/add',
        element: withLoadingComponent(<RentAddOrEditView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 511,
          icon: <SmileOutlined />,
          title: '租赁商品新增',
          hidden: true,
          pid: 510,
        },
      },
      {
        path: '/rentManage/rentGoods/edit',
        element: withLoadingComponent(<RentAddOrEditView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 512,
          icon: <SmileOutlined />,
          title: '租赁商品编辑',
          hidden: true,
          pid: 510,
        },
      },
      {
        path: '/rentManage/rentGoods/detail',
        element: withLoadingComponent(<RentDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 513,
          icon: <ShopOutlined />,
          title: '租赁商品详情',
          hidden: true,
          pid: 510,
        },
      },
      {
        path: '/rentManage/rentMake',
        element: withLoadingComponent(<RentMakeView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 530,
          icon: <ShopOutlined />,
          title: '租赁品牌',
        },
      },
      {
        path: '/rentManage/rentModel',
        element: withLoadingComponent(<RentModeView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 531,
          icon: <ShopOutlined />,
          title: '租赁型号',
          hidden: true,
          pid: 530,
        },
      },
      {
        path: '/rentManage/equipmentOrder',
        element: withLoadingComponent(<EquipmentOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 540,
          title: '租赁订单',
          icon: <ShopOutlined />,
        },
      },
      {
        path: '/rentManage/equipmentOrder/detail',
        element: withLoadingComponent(<EquipmentOrderDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 541,
          title: '租赁订单 / 详情',
          icon: <ShopOutlined />,
          hidden: true,
          pid: 540,
        },
      },
    ],
  },
  {
    path: '/serviceManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 600,
      icon: <ShopOutlined />,
      title: '行业服务',
    },
    children: [
      //  作业服务分类（新）
      {
        path: '/serviceManage/serviceCategoryList',
        element: withLoadingComponent(<ServiceCategoryListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 620,
          title: '作业分类',
          icon: <ShopOutlined />,
        },
      },
      {
        path: '/serviceManage/serviceList',
        element: withLoadingComponent(<ServiceListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 610,
          icon: <ShopOutlined />,
          title: '服务管理',
        },
      },
      {
        path: '/serviceManage/serviceDetail',
        element: withLoadingComponent(<ServiceDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 611,
          icon: <ShopOutlined />,
          title: '服务详情',
          hidden: true,
          pid: 610,
        },
      },
      {
        path: '/serviceManage/demandOrderList/0',
        element: withLoadingComponent(<DemandOrderListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 630,
          title: '任务发单',
          icon: <CreditCardOutlined />,
        },
      },
      {
        path: '/serviceManage/demandOrderList/1',
        element: withLoadingComponent(<DemandOrderListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 640,
          title: '任务接单',
          icon: <CreditCardOutlined />,
        },
      },
      {
        path: '/serviceManage/demandOrderDetail',
        element: withLoadingComponent(<DemandOrderDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 631,
          title: '任务订单详情',
          icon: <CreditCardOutlined />,
          hidden: true,
          pid: 630,
        },
      },
      // {
      //   path: '/serviceManage/serviceOrder',
      //   element: withLoadingComponent(<ServiceOrderView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 830,
      //     title: '服务订单',
      //     icon: <CreditCardOutlined />,
      //     hidden: true,
      //   },
      // },
      // {
      //   path: '/serviceManage/serviceOrder/detail',
      //   element: withLoadingComponent(<ServiceOrderDetail />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 10010,
      //     title: '服务订单 / 详情',
      //     icon: <CreditCardOutlined />,
      //     hidden: true,
      //     pid: 830,
      //   },
      // },
      // {
      //   path: '/mallManage/serviceIntroduce',
      //   element: withLoadingComponent(<ServiceIntroduceView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 10120,
      //     icon: <SmileOutlined />,
      //     title: '服务介绍',
      //     hidden: true,
      //   },
      // },
      // {
      //   path: '/serviceManage/produceList',
      //   element: withLoadingComponent(<ProduceListView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 1050,
      //     icon: <SmileOutlined />,
      //     title: '产品管理',
      //   },
      // },
      // {
      //   path: '/serviceManage/produceDetail',
      //   element: withLoadingComponent(<ProduceDetailView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 10160,
      //     icon: <SmileOutlined />,
      //     title: '产品详情',
      //     hidden: true,
      //     pid: 1050,
      //   },
      // },
      // {
      //   path: '/serviceManage/makeList',
      //   element: withLoadingComponent(<MakeListView />),
      //   errorElement: <ErrorPage />,
      //   meta: {
      //     id: 1060,
      //     icon: <SmileOutlined />,
      //     title: '品牌管理',
      //   },
      // },
    ],
  },
  {
    path: '/pilotTraining',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 700,
      icon: <BankOutlined />,
      title: '执照培训',
    },
    children: [
      {
        path: '/pilotTraining/courseCategory',
        element: withLoadingComponent(<CourseCategoryView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 730,
          title: '培训分类',
          icon: <AppstoreAddOutlined />,
        },
      },
      {
        path: '/pilotTraining/institutionsList',
        element: withLoadingComponent(<InstitutionsListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 710,
          title: '机构介绍',
          icon: <VerifiedOutlined />,
        },
      },
      {
        path: '/pilotTraining/institutionsList/add',
        element: withLoadingComponent(<AddInstitutionsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 711,
          title: '机构上传',
          icon: <UserOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pilotTraining/institutionsList/edit',
        element: withLoadingComponent(<AddInstitutionsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 712,
          title: '机构编辑',
          icon: <UserOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pilotTraining/courseManage',
        element: withLoadingComponent(<CourseManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 720,
          icon: <BookOutlined />,
          title: '课程管理',
        },
      },
      {
        path: '/pilotTraining/pilotTrainingOrder',
        element: withLoadingComponent(<PilotTrainingOrderView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 740,
          title: '培训订单',
          icon: <CreditCardOutlined />,
        },
      },
    ],
  },
  {
    path: '/resourceManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 800,
      icon: <DribbbleOutlined />,
      title: '资源管理',
    },
    children: [
      {
        path: '/resourceManage/requirementsGathering',
        element: withLoadingComponent(<GatheringListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 810,
          title: '需求收集',
          icon: <MonitorOutlined />,
        },
      },
      {
        path: '/resourceManage/gatherDetail',
        element: withLoadingComponent(<GatherDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 811,
          title: '需求详情',
          hidden: true,
          icon: <MonitorOutlined />,
          pid: 810,
        },
      },
      {
        path: '/resourceManage/materielManage',
        element: withLoadingComponent(<MaterielManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 820,
          title: '宣传管理',
          icon: <PictureOutlined />,
        },
      },
      {
        path: '/resourceManage/materielManage/detail',
        element: withLoadingComponent(<MaterielManageDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 821,
          title: '宣传管理详情',
          icon: <SketchOutlined />,
          hidden: true,
          pid: 820,
        },
      },
      {
        path: '/resourceManage/tagManage',
        element: withLoadingComponent(<TagManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 830,
          title: '标签管理',
          icon: <PaperClipOutlined />,
        },
      },
      {
        path: '/resourceManage/industryNews',
        element: withLoadingComponent(<IndustryNewsView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 840,
          title: '行业新闻',
          icon: <ReadOutlined />,
        },
      },
      {
        path: '/resourceManage/tenderManage',
        element: withLoadingComponent(<TenderManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 850,
          title: '招标快讯',
          icon: <CoffeeOutlined />,
        },
      },
      {
        path: '/resourceManage/tenderManage/detail',
        element: withLoadingComponent(<TenderManageDetail />),
        errorElement: <ErrorPage />,
        meta: {
          id: 851,
          title: '招标快讯详情',
          icon: <CoffeeOutlined />,
          hidden: true,
          pid: 850,
        },
      },
      {
        path: '/resourceManage/tenderManage/feedback',
        element: withLoadingComponent(<TenderManageFeedback />),
        errorElement: <ErrorPage />,
        meta: {
          id: 852,
          title: '用户反馈',
          icon: <CoffeeOutlined />,
          hidden: true,
          pid: 850,
        },
      },
      {
        path: '/resourceManage/businessCaseManage',
        element: withLoadingComponent(<BusinessCaseManage />),
        errorElement: <ErrorPage />,
        meta: {
          id: 860,
          title: '业务案例',
          icon: <AliwangwangOutlined />,
        },
      },
      {
        path: '/resourceManage/noticeManage',
        element: withLoadingComponent(<NoticeManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 870,
          title: '通知管理',
          icon: <CommentOutlined />,
        },
      },
    ],
  },
  {
    path: '/activityManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 900,
      icon: <FireOutlined />,
      title: '营销管理',
    },
    children: [
      {
        path: '/activityManage/rewardsManage',
        element: withLoadingComponent(<RewardsManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 910,
          title: '签到奖励',
          icon: <InsertRowAboveOutlined />,
        },
      },
      {
        path: '/activityManage/activityList',
        element: withLoadingComponent(<ActivityListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 920,
          title: '活动管理',
          icon: <WechatOutlined />,
        },
      },
      {
        path: '/activityManage/activityList/detail',
        element: withLoadingComponent(<ActivityListDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 921,
          title: '领取记录',
          icon: <WechatOutlined />,
          hidden: true,
          pid: 920,
        },
      },
    ],
  },
  {
    path: '/forumManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1000,
      icon: <MessageOutlined />,
      title: '社群管理',
    },
    children: [
      {
        path: '/forumManage/topicList',
        element: withLoadingComponent(<TopicListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1020,
          title: '话题列表',
          icon: <ThunderboltOutlined />,
        },
      },
      {
        path: '/forumManage/dynamicList',
        element: withLoadingComponent(<DynamicListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1010,
          title: '帖子列表',
          icon: <ThunderboltOutlined />,
        },
      },
    ],
  },
  // {
  //   path: '/categoryManage',
  //   element: <LayoutView />,
  //   errorElement: <ErrorPage />,
  //   meta: {
  //     id: 1200,
  //     icon: <ReconciliationOutlined />,
  //     title: '分类管理',
  //   },
  //   children: [
  //     {
  //       path: '/categoryManage/jobServicesCategory/1',
  //       element: withLoadingComponent(<CategoryManage />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 1210,
  //         title: '作业服务分类',
  //         icon: <SendOutlined />,
  //       },
  //     },
  //     {
  //       path: '/categoryManage/jobServicesCategory/2',
  //       element: withLoadingComponent(<CategoryManage />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 1220,
  //         title: '设备租赁分类',
  //         icon: <RocketOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/categoryManage/jobServicesCategory/4',
  //       element: withLoadingComponent(<CategoryManage />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 1240,
  //         title: '产品商城分类',
  //         icon: <AppstoreOutlined />,
  //       },
  //     },
  //     {
  //       path: '/categoryManage/jobServicesCategory/0',
  //       element: withLoadingComponent(<CategoryManage />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 1250,
  //         title: '通用分类',
  //         icon: <CoffeeOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/categoryManage/detail/:id',
  //       element: withLoadingComponent(<CategoryDetail />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 18600,
  //         title: '分类详情',
  //         icon: '',
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/categoryManage/DirectoryManage',
  //       element: withLoadingComponent(<DirectoryManage />),
  //       errorElement: <ErrorPage />,
  //       meta: {
  //         id: 1260,
  //         title: '目录管理',
  //         icon: <UnorderedListOutlined />,
  //         hidden: true,
  //       },
  //     },
  //   ],
  // },
  {
    path: '/pointManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1100,
      icon: <AccountBookOutlined />,
      title: '积分管理',
    },
    children: [
      {
        path: '/pointManage/pointList',
        element: withLoadingComponent(<PointList />),
        meta: {
          id: 1110,
          title: '积分列表',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/pointList/detail',
        element: withLoadingComponent(<PointDetail />),
        meta: {
          id: 1111,
          title: '个人积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
          pid: 1110,
        },
      },
      // {
      //   path: '/pointManage/pointRule',
      //   element: withLoadingComponent(<PointRules />),
      //   meta: {
      //     id: 25200,
      //     title: '兑换规则',
      //     icon: <MacCommandOutlined />,
      //   },
      // },
      // {
      //   path: '/pointManage/pointList/list',
      //   element: withLoadingComponent(
      //     <PointDetailList
      //       location={{
      //         search: '',
      //       }}
      //     />,
      //   ),
      //   meta: {
      //     id: 25100,
      //     title: '积分明细',
      //     icon: <MacCommandOutlined />,
      //     hidden: true,
      //   },
      // },
      // {
      //   path: '/pointManage/divideOrder',
      //   element: withLoadingComponent(<DivideOrder />),
      //   meta: {
      //     id: 25300,
      //     title: '订单分成',
      //     icon: <MacCommandOutlined />,
      //   },
      // },
      // {
      //   path: '/pointManage/divideRules',
      //   element: withLoadingComponent(<DivideRules />),
      //   meta: {
      //     id: 25400,
      //     title: '分成规则',
      //     icon: <MacCommandOutlined />,
      //     hidden: true,
      //   },
      // },
    ],
  },
  {
    path: '/depleteManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1200,
      icon: <AccountBookOutlined />,
      title: '消耗管理',
    },
    children: [
      {
        path: '/depleteManage/withDrawList',
        element: withLoadingComponent(<WithDrawListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1210,
          title: '提现列表',
          icon: <SolutionOutlined />,
        },
      },
    ],
  },
  // {
  //   path: '/couponManage',
  //   element: <LayoutView />,
  //   errorElement: <ErrorPage />,
  //   meta: {
  //     id: 26000,
  //     icon: <PayCircleOutlined />,
  //     title: '优惠券管理',
  //   },
  //   children: [
  //     {
  //       path: '/couponManage/couponList',
  //       element: withLoadingComponent(<CouponList />),
  //       meta: {
  //         id: 26100,
  //         title: '活动优惠券',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //     {
  //       path: '/couponManage/couponList/detail',
  //       element: withLoadingComponent(
  //         <CouponDetail
  //           location={{
  //             search: '',
  //           }}
  //         />,
  //       ),
  //       meta: {
  //         id: 26100,
  //         title: '活动优惠券操作',
  //         icon: <PayCircleOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/couponManage/splitCouponList',
  //       element: withLoadingComponent(<SplitCouponList />),
  //       meta: {
  //         id: 26200,
  //         title: '裂变优惠券',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //     {
  //       path: '/couponManage/addOrEditOrDetail',
  //       element: withLoadingComponent(<SplitCouponOperate />),
  //       meta: {
  //         id: 26200,
  //         title: '裂变优惠券操作',
  //         icon: <PayCircleOutlined />,
  //         hidden: true,
  //       },
  //     },
  //     {
  //       path: '/couponManage/couponDetailed',
  //       element: withLoadingComponent(<CouponDetailed />),
  //       meta: {
  //         id: 26300,
  //         title: '优惠券明细',
  //         icon: <PayCircleOutlined />,
  //       },
  //     },
  //   ],
  // },
  // {
  //   path: '/activityManage',
  //   element: <LayoutView />,
  //   errorElement: <ErrorPage />,
  //   meta: {
  //     id: 19000,
  //     icon: <GiftOutlined />,
  //     title: '活动管理',
  //   },
  //   children: [
  //     {
  //       path: '/activityManage/activityList',
  //       element: withLoadingComponent(<ActivityList />),
  //       meta: {
  //         id: 19100,
  //         title: '活动列表',
  //         icon: <GiftOutlined />,
  //       },
  //     },
  //   ],
  // },
  {
    path: '/systemManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 1300,
      icon: <SettingOutlined />,
      title: '系统管理',
    },
    children: [
      {
        path: '/systemManage/accountManage',
        element: withLoadingComponent(<AccountManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1310,
          title: '账号信息',
          icon: <UserOutlined />,
        },
      },
      {
        path: '/systemManage/accountLimit',
        element: withLoadingComponent(<AccountLimit />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1320,
          title: '权限角色',
          icon: <TeamOutlined />,
        },
      },
      {
        path: '/systemManage/limitInfo',
        element: withLoadingComponent(<LimitInfo />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1321,
          title: '权限信息',
          icon: <UserOutlined />,
          hidden: true,
          pid: 1320,
        },
      },
      {
        path: '/systemManage/companyList',
        element: withLoadingComponent(<CompanyListView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1330,
          title: '单位管理',
          icon: <BankOutlined />,
        },
      },
      {
        path: '/systemManage/companyDetail',
        element: withLoadingComponent(<CompanyDetailView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1331,
          title: '单位详情',
          icon: <BankOutlined />,
          hidden: true,
          pid: 1330,
        },
      },
      {
        path: '/systemManage/companyMember',
        element: withLoadingComponent(<CompanyMemberView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1340,
          title: '成员管理',
          icon: <TeamOutlined />,
        },
      },
      {
        path: '/systemManage/addressManage',
        element: withLoadingComponent(<AddressManageView />),
        errorElement: <ErrorPage />,
        meta: {
          id: 1350,
          title: '地址管理',
          icon: <EnvironmentOutlined />,
        },
      },
    ],
  },
];
