// 格式化千分位并补零
export const moneyFormat = (num: number) => {
  if (Number(num).toString() !== 'NaN') {
    // 添加千分符
    let _n = Number(num).toLocaleString();
    if (_n.indexOf('.') !== -1) {
      _n += '00';
    } else {
      _n += '.00';
    }
    // 因为有千分符所以，返回数据为字符串格式，无法做运算操作，适合做直接显示使用
    return _n.substring(0, _n.indexOf('.') + 3);
  }
};
