import {
  abilityListType,
  backDetailPilotType,
  backListPilotType,
  backListReasonType,
  backPilotLogListType,
  getPilotAuditSumType,
  updateAuditStatusType,
  updateRemarkType,
} from '~/api/interface/flyerCenterType';
import axios from '../request';

export class FlyerCenterAPI {
  //飞手列表
  static getBackListPilot: backListPilotType = (data) =>
    axios.post('/userapp/pilot/backListPilot', data);
  //修改备注
  static updateRemark: updateRemarkType = (data) => axios.post('/userapp/pilot/updateRemark', data);
  //  飞手能力类型
  static getAbilityList: abilityListType = () => axios.get('/userapp/pilot/abilityList');
  //  飞手认证日志
  static getBackPilotLogList: backPilotLogListType = (data) =>
    axios.post('/userapp/pilot/backPilotLogList', data);
  //  飞手详情
  static getBackDetailPilot: backDetailPilotType = (params) =>
    axios.get('/userapp/pilot/backDetailPilot', { params });
  //  飞手审批
  static updateAuditStatus: updateAuditStatusType = (data) =>
    axios.post('/userapp/pilot/updateAuditStatus', data);
  //  飞手审批不通过原因
  static getBackListReason: backListReasonType = () => axios.get('/userapp/pilot/backListReason');
  //  飞手审批数据统计
  static getPilotAuditSum: getPilotAuditSumType = () =>
    axios.get('/userapp/pilot/getPilotAuditSum');
}
