// 活动-裂变优惠券下拉类型
import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
import { SplitCouponItemType } from '~/api/interface/couponManage';

// 裂变优惠券-下拉
export type splitCouponDownType = InterFunction<{ type: number }, SplitCouponItemType[]>;

// 活动新增-type
export type addActivityItemType = {
  activityImg: string;
  activityName: string;
  bindingCouponId?: number;
  activityType: number;
  endTime: string;
  helpType: number;
  limitNum: number;
  shareNum: number;
  show: number;
  startTime: string;
  time?: any[];
  redirectPath?: '';
};
export type addActivityType = InterFunction<addActivityItemType, null>;
// 活动-列表
export type activityItemType = addActivityItemType & {
  bindingCouponName: string;
  couponActivityDTO: SplitCouponItemType;
  activityStatus: number;
  activityType: number;
  id: number;
};
export type activeTableItemType = InterItemFunction<any, activityItemType[]>;
// 活动-结束
export type endActivityType = InterFunction<{ activityId: number }, null>;
// 活动-数据
export type activityDataType = InterFunction<
  { activityId: number },
  { countFinishParticipate: number; countParticipate: number }
>;
// 活动-编辑
export type activityEditType = InterFunction<addActivityItemType & { id: number }, null>;
// 后台——签到调整
export type DataInfoType = InterFunction<
  {
    id: number;
    integral: number;
    period: number;
    status: boolean;
    userContinuousCheckInVO: Array<{
      bonusPoints: number;
      numberOfDays: number;
    }>;
  },
  NonNullable<unknown>
>;
// 小程序签到列表
export type SignInListType = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    integral: number;
    period: number;
    status: boolean;
    userContinuousCheckInVO: Array<{
      bonusPoints: number;
      numberOfDays: number;
      id: number;
      signInId: number;
    }>;
  }[]
>;
// 活动列表
export type listActivityPagesType = InterListFunction<
  {
    activityId?: number;
    activityStatus?: number;
    activityType?: number;
    userAccountId?: number;
  },
  {
    activityName: string;
    activityPartDTOS: null;
    activityStatus: number;
    activityType: number;
    createTime: string;
    description: string;
    endTime: string;
    id: number;
    requireNum: number;
    rewardType: number;
    rewardValue: number;
    startTime: string;
  }
>;
// 添加活动
export type activityInsertType = InterFunction<
  {
    activityName: string;
    activityStatus: number;
    activityType: number;
    description: string;
    endTime: string;
    id?: number;
    requireNum: number;
    rewardType: number;
    rewardValue: number;
    startTime: string;
  },
  null
>;
// 修改活动
export type activityUpdateType = InterFunction<
  {
    activityName: string;
    activityStatus: number;
    activityType: number;
    description: string;
    endTime: string;
    id?: number;
    requireNum: number;
    rewardType: number;
    rewardValue: number;
    startTime: string;
  },
  null
>;
// 删除活动
export type activityDeleteType = InterFunction<{ id: number }, null>;
