import { Modal, Table } from 'antd';
import { FC } from 'react';
import { ColumnsType } from 'antd/es/table';
import { PropsType } from '~/common/interface/modal';
import { activityDataType } from '~/api/interface/activityManage';

// 活动数据-类型
type dataType = (ReturnType<activityDataType> extends Promise<infer T> ? T : never)['result'];
interface selfProps {
  activityData: dataType | undefined;
}

const ActivityDataModal: FC<Pick<PropsType, 'isModalVisible' | 'handleCancel'> & selfProps> = ({
  isModalVisible,
  handleCancel,
  activityData,
}) => {
  const columns: ColumnsType<dataType> = [
    {
      title: '参与总人数',
      dataIndex: 'countFinishParticipate',
      align: 'center',
    },
    {
      title: '参与成功人数',
      dataIndex: 'countParticipate',
      align: 'center',
    },
  ];
  return (
    <Modal open={isModalVisible} title='活动数据' onCancel={() => handleCancel()} footer={null}>
      {activityData && (
        <Table
          columns={columns}
          pagination={false}
          dataSource={[activityData]}
          bordered
          rowKey='countFinishParticipate'
        />
      )}
    </Modal>
  );
};
export default ActivityDataModal;
