import { useEffect } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailDelivery from '~/pages/orderManage/productOrder/comp/detailDelivery';
import DetailPurchaser from '~/pages/orderManage/productOrder/comp/detailPurchaser';
import DetailInformation from '~/pages/orderManage/productOrder/comp/detailInformation';

function EquipmentOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 接收到的参数
  const id = searchParams.get('id');
  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // componentDidMount
  useEffect(() => {
    console.log('拿到的id是 --->', id);
  }, [id]);
  return (
    <div className={'order-detail'}>
      <div className={'order-head'}>
        <div className='head-text'>
          <div>
            <span>订单编号：R2023051916330461</span>
            <span>合同编号：UAV202334741131</span>
          </div>
          <div>
            <span>当前状态：交易完成</span>
            <span>创建时间：2023-02-18 10:41:16</span>
          </div>
        </div>
        <Button type={'primary'} onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className={'detail-wrap'}>
        <DetailPurchaser />
        <DetailDelivery />
        <DetailInformation />
      </div>
    </div>
  );
}

export default EquipmentOrderDetail;
