import {
  addCurriculumClassifyType,
  insertOrgType,
  licenceGradeListType,
  licenceModelsListType,
  licenceScaleList,
  licenceTypeListType,
  listOrgPageType,
  removeCurriculumClassifyType,
  removeOrgType,
  selectCurriculumClassifyType,
  updateOrgType,
} from '~/api/interface/pilotTrainType';
import axios from '~/api/request';

export class PilotTrainAPI {
  //    获取执照等级下拉
  static getLicenceGradeList: licenceGradeListType = () =>
    axios.get('/release/licence/pullDown/licenceGradeList');
  //执照机型下拉
  static getLicenceModelsList: licenceModelsListType = () =>
    axios.get('/release/licence/pullDown/licenceModelsList');
  //  机构规模下拉
  static getLicenceScaleList: licenceScaleList = () =>
    axios.get('/release/licence/pullDown/licenceScaleList');
  //  执照类型下拉
  static getLicenceTypeList: licenceTypeListType = () =>
    axios.get('/release/licence/pullDown/licenceTypeList');
  //  机构上传
  static insertOrg: insertOrgType = (data) =>
    axios.post('/release/licence/background/insertOrg', data);
  //  机构列表
  static getListOrgPage: listOrgPageType = (data) =>
    axios.post('/release/licence/background/listOrgPage', data);
  //  机构删除
  static removeOrg: removeOrgType = (params) =>
    axios.get('/release/licence/background/removeOrg', { params });
  //  机构更新
  static updateOrg: updateOrgType = (data) =>
    axios.post('/release/licence/background/updateOrg', data);

  // 所有课程分类列表
  static selectCurriculumClassify: selectCurriculumClassifyType = (params) =>
    axios.get('/release/curriculum/selectCurriculumClassify', { params });

  // 新增课程分类
  static addCurriculumClassify: addCurriculumClassifyType = (params) =>
    axios.post('/release/curriculum/addCurriculumClassify', params);

  // 修改课程分类
  static updateCurriculumClassify: addCurriculumClassifyType = (params) =>
    axios.post('/release/curriculum/updateCurriculumClassify', params);

  // 删除课程分类
  static removeCurriculumClassify: removeCurriculumClassifyType = (params) =>
    axios.get('/release/curriculum/removeCurriculumClassify', { params });
}
