// 行业方案-列表
import { InterFunction, InterItemFunction } from '~/api/interface';

//行业方案-列表
export type listIndustryType = InterItemFunction<
  { categoryId?: number; solutionName?: string },
  {
    categoryId: number;
    categoryName: string;
    createTime: string;
    description: string;
    id: number;
    solutionName: string;
  }[]
>;
//行业方案-新增
export type industryAddType = InterFunction<
  { categoryId: number; description: string; solutionName: string },
  null
>;
//行业方案-编辑
export type industryEditType = InterFunction<
  { categoryId: number; description: string; solutionName: string; id?: number },
  null
>;
//行业方案-删除
export type industryDeleteType = InterFunction<{ id: number }, null>;
//行业方案-详情
export type industryDetailType = InterFunction<
  { id: number },
  {
    categoryId: number;
    description: string;
    solutionName: string;
    categoryName: string;
    id: number;
  }
>;
//行业方案-方案规格列表
export type industrySpecList = InterItemFunction<{ productSkuId: number }, any>;
//行业方案-方案规格-新增
export type industrySpecAdd = InterFunction<
  {
    industrySkuId: number;
    specImage: string;
    specName: string;
    productInventoryList: {
      productSku: {
        id: number;
        productName: string;
        productBrandId: number;
        productBrand: string;
        model: string;
        goodsTypeId: number;
        directoryId: number;
        directoryName: string;
      };
      productSpecList: {
        id: number;
        partNo: string;
        specImage: string;
        specName: string;
        versionDesc: string;
        productSkuId: number;
      }[];
      select: number;
    }[];
  },
  null
>;
//行业方案-方案规格-删除
export type removeIndustrySpecType = InterFunction<{ id: number }, any>;
//行业方案-方案规格-详情
export type industrySpecDetailType = InterFunction<
  { industrySpecId: number },
  {
    id: number;
    industrySkuId: number;
    specImage: string;
    specName: string;
    productInventoryList: {
      productSku: {
        id: number;
        productName: string;
        productBrandId: number;
        productBrand: string;
        model: string;
        goodsTypeId: number;
        directoryId: number;
        categoryName: string;
      };
      productSkuId: number;
      productSpecList: {
        id: number;
        partNo: string;
        specImage: string;
        specName: string;
        versionDesc: string;
        productSkuId: number;
      }[];
      select: number;
    }[];
  }
>;
//行业-方案规格-编辑
export type editIndustrySpecType = InterFunction<
  {
    id: number;
    industrySkuId: number;
    specImage: string;
    specName: string;
    productInventoryList: {
      productSku: {
        id: number;
        productName: string;
        productBrandId: number;
        productBrand: string;
        model: string;
        goodsTypeId: number;
        directoryId: number;
        directoryName: string;
      };
      productSpecList: {
        id: number;
        partNo: string;
        specImage: string;
        specName: string;
        versionDesc: string;
        productSkuId: number;
      }[];
      select: number;
    }[];
  },
  null
>;
