import { FC, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { searchColumns } from '~/components/search-box';
import SearchBox from '~/components/search-box';
import AddOrEditServiceModal from './components/addOrEditServiceModal';
import { Button, Card, Table } from 'antd';
import {
  PlusOutlined,
  ArrowUpOutlined,
  ArrowDownOutlined,
  DeleteOutlined,
} from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';

const ServiceList: FC<any> = () => {
  const navigate = useNavigate();
  const tabList = [
    {
      key: '1',
      tab: '全部',
    },
    {
      key: '2',
      tab: '上架中',
    },
    {
      key: '3',
      tab: '仓库中',
    },
  ];
  const [activeTabKey, setActiveTabKey] = useState<string>('1');
  const [searchColumnsData] = useState<searchColumns[]>([
    {
      type: 'input',
      placeholder: '请输入服务名称',
      label: '服务名称',
      name: '',
    },
    {
      type: 'select',
      placeholder: '请选择应用类型',
      label: '应用类型',
      name: '',
      options: [],
    },
    {
      type: 'select',
      placeholder: '请选择对应行业',
      label: '对应行业',
      name: '',
      options: [],
    },
  ]);
  const tableColumns: ColumnsType<any> = [
    { title: '序号', align: 'center' },
    { title: '服务名称', align: 'center' },
    { title: '应用', align: 'center' },
    { title: '对应行业', align: 'center' },
    { title: '封面图', align: 'center' },
    { title: '分享卡片', align: 'center' },
    { title: '视频', align: 'center' },
    {
      title: '服务介绍',
      align: 'center',
      render: () => (
        <Button type='link' onClick={toServiceIntroduce}>
          --
        </Button>
      ),
    },
    { title: '状态', align: 'center' },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link' onClick={toServiceDetail}>
            详情
          </Button>
        </>
      ),
    },
  ];
  const [tableData] = useState<{ id: number }[]>([{ id: 1 }]);
  //新增、编辑服务弹窗
  const [addOrEditServiceModalOpen, setAddOrEditServiceModalOpen] = useState<boolean>(false);
  const [addOrEditServiceModalTitle, setAddOrEditServiceModalTitle] = useState<string>('新增服务');

  const onTabChange = (key: string) => {
    setActiveTabKey(key);
  };
  //新增服务
  const addServiceModalShow = () => {
    setAddOrEditServiceModalTitle('新增服务');
    setAddOrEditServiceModalOpen(true);
  };

  const addOrEditServiceModalCancel = () => {
    setAddOrEditServiceModalOpen(false);
  };
  //服务详情
  const toServiceDetail = () => {
    navigate({ pathname: '/mallManage/serviceDetail' });
  };
  //服务介绍
  const toServiceIntroduce = () => {
    navigate({ pathname: '/mallManage/serviceIntroduce' });
  };

  return (
    <div className='service-list'>
      <SearchBox
        search={searchColumnsData}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={addServiceModalShow}>
            新增服务
          </Button>
        }
      />
      <Card tabList={tabList} activeTabKey={activeTabKey} onTabChange={onTabChange}>
        <div className='header-operate' style={{ marginBottom: '10px' }}>
          <Button type='primary' style={{ marginRight: '10px' }} icon={<ArrowUpOutlined />}>
            上架
          </Button>
          <Button type='primary' style={{ marginRight: '10px' }} icon={<ArrowDownOutlined />}>
            下架
          </Button>
          <Button danger icon={<DeleteOutlined />}>
            删除
          </Button>
        </div>
        <Table columns={tableColumns} bordered dataSource={tableData} />
      </Card>
      {/*新增/编辑服务弹窗*/}
      <AddOrEditServiceModal
        open={addOrEditServiceModalOpen}
        title={addOrEditServiceModalTitle}
        onCancel={addOrEditServiceModalCancel}
      />
    </div>
  );
};
export default ServiceList;
