import React, { useEffect, useState } from 'react';
import { store } from '~/store';
import { InterDataType } from '~/api/interface';
import { SystemManageAPI } from '~/api';
import { getCompanyInfoByIdType } from '~/api/interface/systemManageType';
import './index.scss';
import StoreFormView from '~/pages/resourceManage/storeDecorate/comp/storeFormView';
import StoreBusinessCase from '~/pages/resourceManage/storeDecorate/comp/storeBusinessCase';
import StoreSolutionView from '~/pages/resourceManage/storeDecorate/comp/storeSolutionView';

// 店铺类型
type StoreType = InterDataType<getCompanyInfoByIdType>;

const StoreDecoratePage: React.FC = () => {
  const [storeDetail, setStoreDetail] = useState<StoreType>();
  // 获取店铺数据
  const getStoreApplyDetail = async () => {
    const res = await SystemManageAPI.getCompanyInfoById({
      id: store.getState().UserInfo.userInfo?.companyInfoVO?.id,
    });
    if (res && res.code === '200') {
      setStoreDetail(res.result);
      // console.log('获取店铺数据 --->', res.result);
    }
  };
  // 页面挂载
  useEffect(() => {
    if (store.getState().UserInfo?.userInfo?.companyInfoVO?.id) getStoreApplyDetail().then();
    // console.log('页面挂载 --->', store.getState().UserInfo?.userInfo);
  }, []);
  return (
    <div className={'store-decorate-wrap flex-start'}>
      {!!storeDetail?.id && (
        <>
          <div className={'store-form'}>
            <StoreFormView detail={storeDetail} onRefresh={getStoreApplyDetail} />
          </div>
          {storeDetail?.cooperationTagId === 5 ? (
            <div className={'store-solution'}>
              <StoreSolutionView detail={storeDetail} />
            </div>
          ) : (
            <div className={'store-solution'}>
              <StoreBusinessCase detail={storeDetail} />
            </div>
          )}
        </>
      )}
    </div>
  );
};

export default StoreDecoratePage;
