import { Modal, ModalProps, Steps } from 'antd';
import React, { FC } from 'react';
import { InterDataType } from '~/api/interface';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
// 商品订单详情返回类型
type DataType = InterDataType<mallOrderDetailType>;
interface selfProps {
  logisticsStep: DataType['kdnExpDTO'];
}

const LogisticsStepModal: FC<ModalProps & selfProps> = ({ open, onCancel, logisticsStep }) => {
  return (
    <Modal open={open} title='物流进度' onCancel={onCancel} footer={false}>
      {logisticsStep?.traces?.length ? (
        <Steps
          direction='vertical'
          current={(logisticsStep?.traces?.length || 1) - 1}
          progressDot
          items={logisticsStep?.traces?.map((v) => ({
            title: v.acceptStation,
            description: v.acceptTime,
          }))}
        />
      ) : (
        <div className='no-data' style={{ color: '#999', textAlign: 'center' }}>
          暂无物流
        </div>
      )}
    </Modal>
  );
};
export default LogisticsStepModal;
