import { FC, useEffect, useState } from 'react';
import { Button, Image, Modal, ModalProps } from 'antd';
import './index.scss';
import { InterDataType } from '~/api/interface';
import { forumDetailType } from '~/api/interface/forumManageType';
import { ForumManageAPI } from '~/api';
//论坛详情返回类型
type detailType = InterDataType<forumDetailType>;
interface selfProps {
  forumDetail?: detailType;
}
const DynamicDetailModal: FC<ModalProps & selfProps> = ({ open, onCancel, forumDetail }) => {
  const getLikeUserInfo = (dynamicId: number) => {
    ForumManageAPI.getLikeUserInfoList({ dynamicId }).then(({ result }) => {});
  };
  useEffect(() => {
    if (forumDetail && forumDetail.likesCount) {
      getLikeUserInfo(forumDetail.id);
    }
  }, [forumDetail]);
  return (
    <Modal open={open} onCancel={onCancel} title='查看详情' width={800} footer={null}>
      <div className='dynamic-detail'>
        <div className='dynamic-detail-media'>
          {forumDetail?.mediaVO?.map((v, index: number) => {
            if (v.type === 0) {
              return (
                <div className='media-item' key={index}>
                  <Image src={v.url} width={200} height={200} />
                </div>
              );
            } else {
              return (
                <div className='media-item' key={index}>
                  <video
                    src={v.url}
                    style={{
                      width: '200px',
                      height: '200px',
                      verticalAlign: 'top',
                    }}
                    controls
                  />
                </div>
              );
            }
          })}
        </div>
        <div className='dynamic-detail-info'>
          <div className='info-title'>{forumDetail?.description}</div>
          <div className='info-footer'>
            <div className='time'>发布于{forumDetail?.dynamicPublishTime}</div>
            <div className='operate'>
              <div>{forumDetail?.commentCount}人回答</div>
              <Button type='link'>{forumDetail?.likesCount}人爱心赞</Button>
            </div>
          </div>
        </div>
        {forumDetail?.commentAndReplyVO.length ? (
          <div className='dynamic-detail-comment'>
            <div className='comment-title'>{forumDetail?.commentCount}条评论</div>
            {forumDetail.commentAndReplyVO.map((v, index: number) => (
              <div className='comment-item' key={index}>
                <div className='comment-item-header'>
                  <div className='user-avatar'>
                    <img src={v.userBaseInfo.userImg} alt='头像' />
                  </div>
                  <div className='user-name'>{v.userBaseInfo.nickName}</div>
                </div>
                <div className='comment-item-info'>
                  <div className='info-content'>{v.description}</div>
                  <div className='info-time'>{v.dynamicPublishTime}</div>
                </div>
              </div>
            ))}
          </div>
        ) : (
          <div className='no-comment'>暂无评论</div>
        )}
      </div>
    </Modal>
  );
};
export default DynamicDetailModal;
