import { useEffect, useState } from 'react';
import { Button, Table } from 'antd';
import { EditOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import { useNavigate } from 'react-router-dom';
// import { UserAPI } from '@/api';
import SearchBox, { searchColumns } from '~/components/search-box';
// import useOption from '@/common/hook/optionHook';
import { FormType, TableType } from './propsType';
import { moneyFormat } from '~/utils/money';
import qs from 'query-string';

const CustomMoneyView = () => {
  // 路由操作
  const navigate = useNavigate();
  // 搜索数据
  const [searchColumns] = useState<searchColumns[]>([
    {
      label: '用户信息',
      name: 'searchKey',
      type: 'input',
      placeholder: '用户名称/手机号/UID',
      width: 180,
    },
  ]);
  // 表头
  const tableColumns: ColumnsType<TableType> = [
    {
      title: '用户UID',
      dataIndex: 'uid',
      align: 'center',
    },
    {
      title: '用户名称',
      dataIndex: 'userName',
      align: 'center',
      render: (_value, record) => {
        return record.userName ? record.userName : record.nickName ? record.nickName : `游客用户`;
      },
    },
    {
      title: '手机号',
      dataIndex: 'phoneNum',
      align: 'center',
      render: (value) => {
        return value || `-`;
      },
    },
    {
      title: '已销耗（元）',
      dataIndex: 'rebatePaid',
      align: 'center',
      render: (value) => {
        return moneyFormat(value);
      },
    },
    {
      title: '已冻结（元）',
      dataIndex: 'rebateFreeze',
      align: 'center',
      render: (value) => {
        return moneyFormat(value);
      },
    },
    {
      title: '奖励金账户（元）',
      dataIndex: 'rcdRebateAmt',
      align: 'center',
      render: (value) => {
        return moneyFormat(value);
      },
    },
    {
      title: '操作',
      align: 'center',
      width: 150,
      fixed: 'right',
      render: (_value, record, _index) => (
        <Button
          type='link'
          size='small'
          icon={<EditOutlined />}
          onClick={() => handleDetail(record)}
        >
          变更
        </Button>
      ),
    },
  ];
  // 表格数据
  const [tableData, setTableData] = useState<TableType[]>([]);
  // 表格分页配置
  const [pagination, setPagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 按钮权限
  // const btnChange = useOption(21101);

  // 新版通用部分(ES6+ for React) ZhangLK 2022/08/30 Start
  // 加载列表
  const getTableList = async (value = {}) => {
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    setTableData([{ id: 1, uid: 'UID1234132', userName: '刘旺' }]);
    // 只需要修改这个地方的接口即可
    // const res: any = await UserAPI.getBountyManageList({
    //   pageNo: pagination.current,
    //   pageSize: pagination.pageSize,
    //   ...value,
    // });
    // if (res && res.code === '200') {
    //   // console.log("res -->", res);
    //   const { list, pageNo, totalCount, pageSize, totalPage } = res.result; // 解构
    //   setPagination({
    //     total: totalCount,
    //     pageSize,
    //     current: pageNo,
    //     totalPage,
    //   });
    //   setTableData(list);
    // } else {
    //   message.warning(res.message);
    // }
  };
  // 翻页
  const paginationChange = (pageNo: number, pageSize: number) => {
    getTableList({ pageNo, pageSize }).then();
  };
  // 表单提交
  const onFinish = (val: FormType) => {
    // 在这里对提交的数据做处理，如range转为开始和结束时间
    const data = Object.fromEntries(
      // 过滤为空项
      Object.entries({
        ...val,
        pageNo: 1,
      }).filter((i) => i[1] !== '' && i[1] !== undefined && i[1] !== null),
    );
    getTableList(data).then();
  };
  // 跳转详情
  const handleDetail = (record: TableType) => {
    const search = {
      id: record.id,
      uid: record.uid,
      userName: record.userName ? record.userName : record.nickName ? record.nickName : `游客用户`,
    };
    navigate(`/customManage/customMoney/detail?${qs.stringify(search)}`);
    // console.log(record);
  };

  // componentDidMount
  useEffect(() => {
    getTableList().then();
  }, []);

  return (
    <>
      <SearchBox search={searchColumns} searchData={onFinish} />
      <Table
        size='small'
        rowKey='id'
        dataSource={tableData}
        columns={tableColumns}
        scroll={{ x: 1500 }}
        pagination={{
          total: pagination.total,
          pageSize: pagination.pageSize,
          current: pagination.current,
          showSizeChanger: true,
          onChange: (page, pageSize) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
        bordered
      />
    </>
  );
};

export default CustomMoneyView;
