import { CommonAPI } from '~/api';
import { message } from 'antd';

// 上传文件
export const uploadFile = (file: any): Promise<string> =>
  new Promise((resolve, reject) => {
    // 上传到服务器
    const formData = new FormData();
    formData.append('uploadFile', file);
    CommonAPI.uploadOssBP(formData).then((res) => {
      if (res && res.code === '200') {
        resolve(res.result);
        return;
      } else {
        reject(res);
        message.error('文件上传失败').then();
        return;
      }
    });
  });
