import './index.scss';
import * as echarts from 'echarts';
import { useEffect, useState } from 'react';
import { DataDashboardsAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { orderReportDataType } from '~/api/interface/dataDashboardsType';
import dayjs from 'dayjs';

// 数据看板-订单数据返回类型
type orderDataType = InterDataType<orderReportDataType>;
const TradeInfo = () => {
  const [orderData, setOrderData] = useState<orderDataType>();
  // 表格数据
  const [tableData, setTableData] = useState<{ label: string; orderCount: number; GMV: number }[]>(
    [],
  );
  //   初始化柱状图
  const initEchartsBar = (totalPriceCount: number[]) => {
    const myChart = echarts.init(document.getElementById('histogram'));
    myChart.setOption({
      legend: {
        right: 20,
        top: 0,
        data: [
          {
            name: '总交易额',
            icon: 'pin',
          },
        ],
      },
      xAxis: {
        data: ['商城', '租赁', '服务'],
        axisLabel: {
          color: '#000',
          fontSize: 15,
        },
      },
      yAxis: {},
      series: [
        {
          name: '总交易额',
          type: 'bar',
          data: totalPriceCount,
          barWidth: '13',
          itemStyle: {
            barBorderRadius: [7, 7, 0, 0],
            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
              { offset: 0, color: '#F22D40' },
              { offset: 1, color: '#FFFFFF' },
            ]),
          },
        },
      ],
    });
    window.addEventListener('resize', function () {
      myChart.resize();
    });
  };
  // 数据看板-订单数据
  const getOrderReportData = () => {
    DataDashboardsAPI.getOrderReportData().then(({ result }) => {
      if (result) {
        setOrderData(result);
        initEchartsBar([result.saleGMV, result.leaseGMV, result.serviceGMV]);
        setTableData([
          {
            label: '商城售卖',
            orderCount: result.saleOrderCount,
            GMV: result.saleGMV,
          },
          {
            label: '商品租赁',
            orderCount: result.leaseOrderCount,
            GMV: result.leaseGMV,
          },
          {
            label: '服务订单',
            orderCount: result.serviceOrderCount,
            GMV: result.serviceGMV,
          },
        ]);
      }
    });
  };

  useEffect(() => {
    getOrderReportData();
  }, []);

  return (
    <div className='trade-info'>
      <div className='trade-info-card-1'>
        <div className='total-price'>{orderData?.totalGMV.toLocaleString()}</div>
        <div className='total-price-meta'>实时交易总额 (GMV)</div>
        <div className='time'>{dayjs().format('MM-DD')}更新</div>
      </div>
      <div className='trade-info-card-2'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>交易详情</div>
        </div>
        <div className='card-echarts' id='histogram'></div>
        <div className='card-table'>
          <div className='card-table-header'>
            <div className='header-td'>类型</div>
            <div className='header-td'>订单总数(个)</div>
            <div className='header-td'>交易总额(元)</div>
          </div>
          {tableData.map((v, index) => (
            <div className='card-table-tr' key={index}>
              <div className='td'>{v.label}</div>
              <div className='td'>{v.orderCount}</div>
              <div className='td'>¥{v.GMV.toLocaleString()}</div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};
export default TradeInfo;
