import { Form, Input, message, Modal, ModalProps } from 'antd';
import { FC, useEffect } from 'react';
import { InterDataType } from '~/api/interface';
import { listAuthPageType } from '~/api/interface/customManageType';
import { CustomManageAPI } from '~/api';

type listAuthType = InterDataType<listAuthPageType>['list'];

interface selfProps {
  onOk: () => void;
  currentAuthItem: listAuthType[0] | undefined;
}

//实名认证列表返回类型
const RemarkModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, currentAuthItem }) => {
  const [form] = Form.useForm<{ remark: string }>();

  const handleOk = () => {
    if (currentAuthItem) {
      form.validateFields().then((values) => {
        CustomManageAPI.updateRemark({ id: currentAuthItem.id, ...values }).then(({ code }) => {
          if (code === '200') {
            message.success('更新备注成功');
            onOk();
          }
        });
      });
    }
  };

  useEffect(() => {
    if (currentAuthItem) {
      form.setFieldValue('remark', currentAuthItem.remark || undefined);
    }
  }, [currentAuthItem]);
  return (
    <Modal open={open} onCancel={onCancel} onOk={handleOk} title='备注弹窗'>
      <Form form={form}>
        <Form.Item label='备注' name='remark'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} showCount rows={4} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default RemarkModal;
