import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
import { PaginationEntity } from '~/common/interface/PaginationEntity';

// 裂变优惠券-表格数据类型
export type SplitCouponItemType = {
  id: number;
  activityRole: string;
  couponStatus: boolean;
  amountReceived: number;
  userTag: number;
  peopleNumber: number;
  beSharedCoupon: SplitCouponItemType;
  isFixedTime?: number;
} & shareCouponType &
  baseInfoType;
export type SplitCouponSearchType = {
  couponId?: string;
  couponName?: string;
  endTime?: string;
  startTime?: string;
  useType?: number;
  state?: boolean;
};
export type SplitCouponListType = InterItemFunction<SplitCouponSearchType, SplitCouponItemType[]>;
// 裂变优惠券-新建-数据类型
// 基本信息
export type baseInfoType = {
  couponName: string;
};
// 分享者优惠券
export type shareCouponType = {
  useType: number;
  primaryKey: number[];
  useStartTime: string;
  useEndTime: string;
  couponMoney: number;
  couponType: number;
  minPrice: number;
  couponDiscount: number;
  verificationType: number;
  couponTotal: number;
  restrictedAccess: number;
  userTag: number;
};
// 被分享者优惠券
export type sharedCouponType = {
  beSharedCouponDiscount: number;
  beSharedCouponMoney: number;
  beSharedCouponType: number;
  beSharedMinPrice: number;
  beSharedPrimaryKey: number[];
  beSharedUseType: number;
  beSharedVerificationType: number;
  beSharedCouponTotal: number;
};

export type SplitCouponAddType = InterItemFunction<
  baseInfoType & shareCouponType & sharedCouponType,
  null
>;

// 优惠券列表-分页
export type CouponPageListType = InterListFunction<
  {
    couponId?: string;
    couponName?: string;
    endTime?: string;
    startTime?: string;
    state?: boolean;
    useType?: number;
  },
  {
    file: any;
    couponDay: number;
    couponDiscount: number;
    couponMoney: number;
    couponName: string;
    couponStatus: boolean;
    couponTotal: number;
    couponType: number;
    createTime: string;
    getType: number;
    id: number;
    isDel: boolean;
    isFixedTime: number;
    isLimited: boolean;
    lastTotal: number;
    minPrice: number;
    preferentialLimit: number;
    primaryKey: string;
    restrictedAccess: number;
    updateTime: string;
    useEndTime: string;
    useStartTime: string;
    useType: number;
    userTag: number;
    verificationType: boolean;
    fileUrl: string;
  }
>;

// 优惠券明细
export type couponDetailSearchType = {
  couponId?: number;
  createTime?: string;
  endTime?: string;
  gainType?: string;
  orderNumber?: string;
  startTime?: string;
  state?: number;
  uid?: string;
  useTime?: string;
  userPhone?: string;
};
export type couponDetailItemType = {
  cid: number;
  couponId: number;
  couponName: string;
  uid: string;
  userPhone: string;
  gainType: string;
  status: number;
  useTime: string;
  orderNo: string;
  useType: number;
  createTime: string;
  conversionRatio: number;
  transferorUid: string;
  receiveUid: string;
  transferorTime: string;
};

export type couponDetailType = InterItemFunction<couponDetailSearchType, couponDetailItemType[]>;

export type couponDetailExportType = InterFunction<
  couponDetailSearchType & Pick<PaginationEntity, 'pageNo' | 'pageSize'>,
  any
>;

// 品牌列表
export type ListBrandInfoType = InterListFunction<
  {},
  { brandName: string; createTime: string; id: number }
>;

// 新增优惠券
export type CouponSaveType = InterFunction<any, any>;

// 增发优惠券
export type CouponIncreaseType = InterFunction<{ id: number; count: number }, {}>;

// 获取优惠券使用数据
export type CouponGetDataType = InterFunction<
  { id: number },
  {
    accountPaid: number;
    availability: string;
    claimRate: string;
    couponTotal: number;
    receiveQuantity: number;
    usageAmount: number;
  }
>;

// 关闭优惠券类型
export type CouponShutDownType = InterFunction<{ id: number }, {}>;
