import { FC } from 'react';
import { Button, Col, Form, Input, Modal, Row, Select, Upload } from 'antd';
import { ModalProps } from 'antd';
import { UploadOutlined } from '@ant-design/icons';

const AddOrEditServiceModal: FC<ModalProps> = ({ open, title, onCancel }) => {
  return (
    <Modal open={open} title={title} onCancel={onCancel}>
      <Form labelCol={{ span: 4 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='服务名称'>
          <Input placeholder='请输入服务名称' />
        </Form.Item>
        <Form.Item label='应用'>
          <Select placeholder='请选择应用'>
            <Select.Option>111</Select.Option>
          </Select>
        </Form.Item>
        <Form.Item label='对应行业'>
          <Select placeholder='请选择对应行业'>
            <Select.Option>111</Select.Option>
          </Select>
        </Form.Item>
        <Form.Item label='封面图'>
          <Upload listType='picture-card'>
            <UploadOutlined />
          </Upload>
        </Form.Item>
        <Form.Item label='分享卡片'>
          <Upload listType='picture-card'>
            <UploadOutlined />
          </Upload>
        </Form.Item>
        <Form.Item label='视频'>
          <Row>
            <Col></Col>
            <Col>
              <Upload>
                <Button icon={<UploadOutlined />} size='small' type='primary'>
                  上传
                </Button>
              </Upload>
            </Col>
          </Row>
        </Form.Item>
        <Form.Item label='展示状态'>
          <Select placeholder='请选择展示状态'>
            <Select.Option>上架</Select.Option>
            <Select.Option>下架</Select.Option>
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditServiceModal;
