import axios from '../request';
import {
  applyTagDetails,
  approvalApplyTag,
  changeUserTagNew,
  changeUserTagType,
  CompanyListTag,
  cooperationListTag,
  deleteApplyTag,
  editUserApplyTag,
  editUserApplyTagDetails,
  listAppUserType,
  listUserApplyTag,
  userAccountUpdateType,
} from '~/api/interface/customManageType';

export class CustomManageAPI {
  // 客户列表
  static listAppUser: listAppUserType = (params) =>
    axios.post('/userapp/user-account/listAppUser', params);
  // 加盟列表
  static CompanyListTag: CompanyListTag = (params) =>
    axios.get('/userapp/cooperation/listTag', { params });
  // 客户列表
  static userAccountUpdate: userAccountUpdateType = (params) =>
    axios.post('/userapp/user-account/update', params);
  // 后台设置小程序用户标签
  static changeUserTag: changeUserTagType = (params) =>
    axios.get('/userapp/cooperation/changeUserTag', { params });
  // 后台设置小程序用户标签
  static changeUserTagNew: changeUserTagNew = (params) =>
    axios.post('/userapp/cooperation/changeUserTag', params);
  // 加盟标签列表
  static cooperationListTag: cooperationListTag = (params) =>
    axios.get('/userapp/cooperation/listTag', { params });
  // 后台申请列表
  static listUserApplyTag: listUserApplyTag = (params) =>
    axios.post('/userapp/cooperation/listUserApplyTag', params);
  // 审批详情
  static applyTagDetails: applyTagDetails = (params) =>
    axios.get('/userapp/cooperation/applyTagDetails', { params });
  // 审批
  static approvalApplyTag: approvalApplyTag = (params) =>
    axios.get('/userapp/cooperation/approvalApplyTag', { params });
  // 强制删除
  static deleteApplyTag: deleteApplyTag = (params) =>
    axios.get('/userapp/cooperation/deleteApplyTag', { params });
  // 后台-编辑详情信息
  static editUserApplyTagDetails: editUserApplyTagDetails = (params) =>
    axios.get('/userapp/cooperation/editUserApplyTagDetails', { params });
  // 后台-编辑服务商信息
  static editUserApplyTag: editUserApplyTag = (params) =>
    axios.post('/userapp/cooperation/editUserApplyTag', params);
}
