import React from 'react';
import { Button, Image } from 'antd';
import { getMallOrderDetailById } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';

// 接口返回的类型
type DataType = InterDataType<getMallOrderDetailById>;
// 参数类型
type PropsType = {
  detail: DataType;
};

const DetailPurchaser: React.FC<PropsType> = (props) => {
  const { detail } = props;

  return (
    <div className={'detail-purchaser detail-half'}>
      <div className={'detail-title'}>买家信息</div>
      <div className={'detail-text'}>UID：{detail?.uid}</div>
      <div className={'detail-text'}>姓名： {detail?.userName}</div>
      <div className={'detail-text'}>手机号： {detail?.phoneNum}</div>
      {/*<div className={'detail-text'}>企业： 浙江科比特创新科技有限公司</div>*/}
      <div className={'detail-text'}>备注： {detail?.remark}</div>

      <div style={{ display: 'none' }}>
        <div className={'detail-title'}>合同信息</div>
        <div className={'detail-text'}>合同编号： UAV202334741131</div>
        <div className={'detail-text'}>合同状态： 已归档</div>
        <div className={'detail-text'}>
          合同操作：
          <Button type={'link'}>平台签署</Button>
          <Button type={'link'}>查看</Button>
          <Button type={'link'}>下载</Button>
        </div>
      </div>

      <div className={'detail-title'}>付款凭证</div>
      <div className={'detail-text'}>预付款：</div>
      <div className={'detail-image'}>
        {[
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
        ].map((i, j) => (
          <Image key={j} className={'image'} src={i} alt='付款凭证' />
        ))}
      </div>
      <div className={'detail-text'}>尾款：</div>
      <div className={'detail-image'}>
        {[
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
        ].map((i, j) => (
          <Image key={j} className={'image'} src={i} alt='付款凭证' />
        ))}
      </div>
      <div className={'detail-text'}>全款：</div>
      <div className={'detail-image'}>
        {[
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
          'https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/infrastructure-05-05.png',
        ].map((i, j) => (
          <Image key={j} className={'image'} src={i} alt='付款凭证' />
        ))}
      </div>
    </div>
  );
};

export default DetailPurchaser;
