import { FC } from 'react';
import { Button, Cascader, Col, Form, Input, Modal, ModalProps, Row, Table, Upload } from 'antd';
import './index.scss';
import { ColumnsType } from 'antd/es/table/InternalTable';
import { UploadOutlined } from '@ant-design/icons';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
}

const SureOrder: FC<ModalProps & selfProps> = ({ open, onOk, onCancel }) => {
  const tableColumns: ColumnsType<any> = [
    {
      title: '商品',
      align: 'center',
    },
    {
      title: '价格',
      align: 'center',
    },
    {
      title: '数量',
      align: 'center',
    },
  ];

  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };
  return (
    <Modal open={open} title='确认订单' onOk={handleOk} onCancel={handleCancel} width={800}>
      <div className='sure-order'>
        <div className='address-info'>
          <div className='address-info-title'>收货信息：</div>
          <div className='address-info-form'>
            <Form labelCol={{ span: 5 }} wrapperCol={{ span: 16 }}>
              <Form.Item
                label='收货人'
                name='takeName'
                // rules={[{ required: true, validator: validateUserName }]}
              >
                <Input placeholder='请输入收货人' style={{ width: '300px' }} />
              </Form.Item>
              <Form.Item
                label='联系方式'
                name='takePhone'
                // rules={[{ required: true, validator: validatePhone }]}
              >
                <Input placeholder='请输入联系方式' style={{ width: '300px' }} />
              </Form.Item>
              <Form.Item
                label='所属地区'
                rules={[{ required: true, message: '请输入所属地区' }]}
                name='takeRegion'
              >
                <Cascader
                  // options={location}
                  style={{ width: '300px' }}
                  fieldNames={{
                    label: 'name',
                    value: 'name',
                    children: 'childInfo',
                  }}
                  placeholder='请选择所属地区'
                />
              </Form.Item>
              <Form.Item
                label='详细地址'
                name='takeAddress'
                rules={[{ required: true, message: '请输入详细地址' }]}
              >
                <Input.TextArea
                  maxLength={250}
                  placeholder='请输入详细地址'
                  showCount
                  rows={4}
                  style={{ width: '300px' }}
                />
              </Form.Item>
            </Form>
          </div>
        </div>
        <div className='order-info'>
          <div className='order-info-title'>订单信息：</div>
          <Row>
            <Col span={3}></Col>
            <Col span={16}>
              <div className='order-info-table'>
                <Table bordered columns={tableColumns} />
              </div>
              <div className='order-info-form'>
                <Form wrapperCol={{ span: 10 }} labelCol={{ span: 3 }}>
                  <Form.Item label='订单交期'>
                    <Input placeholder='请输入订单交期' />
                  </Form.Item>
                  <Form.Item label='付款期限'>
                    <Input placeholder='请输入付款期限' />
                  </Form.Item>
                </Form>
              </div>
            </Col>
          </Row>
        </div>
        <div className='contract-info'>
          <div className='contract-info-title'>合同签署：</div>
          <div className='contract-info-form'>
            <Form labelCol={{ span: 4 }} wrapperCol={{ span: 16 }}>
              <Form.Item label='合同'>
                <Upload>
                  <Button icon={<UploadOutlined />}>上传</Button>
                </Upload>
              </Form.Item>
            </Form>
          </div>
        </div>
      </div>
    </Modal>
  );
};
export default SureOrder;
