import { useEffect, useState } from 'react';
import { Breadcrumb, Layout } from 'antd';
import { useLocation } from 'react-router-dom';
import { GetRouteByPath, getRouteParent } from '~/utils/router';
import { routerList } from '~/router/router';
import { ItemType } from 'antd/es/breadcrumb/Breadcrumb';

const { Header } = Layout;

function HeaderView() {
  // 当前路由
  const location = useLocation();
  // 面包屑数据
  const [header, setHeader] = useState<ItemType[]>([]);
  // 根据路由获取当前的面包屑
  const setBreadcrumbTitle = () => {
    const pTitle = getRouteParent(routerList, location.pathname)?.meta.title;
    const title = GetRouteByPath(location.pathname, routerList)?.meta.title;
    setHeader([{ title: pTitle }, { title }]);
  };

  // componentDidMount
  useEffect(() => {
    setBreadcrumbTitle();
  }, [location]);

  return (
    <Header>
      <Breadcrumb items={header} />
    </Header>
  );
}

export default HeaderView;
