import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// web 租赁订单-分页-列表
export type listOfRentalOrdersType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// 后台管理 租赁订单-分页-列表
export type listPcWechatOrderType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// web/小程序——订单详情
export type orderDetailType = InterFunction<
  { orderNo: string },
  {
    actualPay: number;
    balance: number;
    buyerName: string;
    buyerPhone: string;
    couponId: number;
    createTime: string;
    deposit: number;
    doing: string;
    endDate: string;
    exWare: number;
    express: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    id: number;
    leaseOrderStatus: string;
    nickName: string;
    orderNo: string;
    orderRefund: {
      actualRefund: number;
      createTime: string;
      id: number;
      orderInfo: {};
      orderInfoId: number;
      orderVcu: {
        id: number;
        imgs: Array<string>;
        orderInfoId: number;
        remark: string;
        vcuSatus: number;
        vcuType: number;
        videoUrl: string;
      };
      pfRemark: string;
      reason: string;
      refundCash: {
        amtPaid: number;
        cashAmt: number;
        createUser: number;
        id: number;
        opName: string;
        opNo: string;
        orderNo: string;
        payMethod: number;
        payNo: string;
        payTime: string;
        refundNo: string;
        remark: string;
        voucher: Array<string>;
        wareTitle: string;
      };
      refundNo: string;
      refundStatus: number;
      rlogs: Array<{
        createTime: string;
        msg: string;
        opAccount: string;
        opName: string;
      }>;
      shouldRefund: number;
    };
    orderType: number;
    payDay: number;
    payNo: string;
    payTime: string;
    pfRemark: string;
    receipt: {
      bookPhone: string;
      detailAddress: string;
      id: number;
      receiptMethod: number;
      region: string;
      renAddress: string;
      renExCode: string;
      renExNo: string;
      renMethod: number;
      renName: string;
      renPhone: string;
      renRepoAddr: string;
      renRepoName: string;
      renRepoPhone: string;
      repoAddress: string;
      repoName: string;
      sendAddress: string;
      sendExCode: string;
      sendExNo: string;
      takeName: string;
      takePhone: string;
    };
    refundExpress: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    remark: string;
    rentPrice: number;
    repoAccountId: number;
    returnTime: string;
    sendWareTime: string;
    shouldPay: number;
    shutReason: string;
    skuInfoId: number;
    skuTitle: string;
    specsId: number;
    startDate: string;
    tranStatus: string;
    uid: string;
    unitPrice: number;
    vcus: Array<{
      id: number;
      imgs: Array<string>;
      orderInfoId: number;
      remark: string;
      vcuSatus: number;
      vcuType: number;
      videoUrl: string;
    }>;
    waiting: string;
    wareDescription: string;
    wareImg: string;
    wareInfoId: number;
    wareNo: string;
    wareNum: number;
    wareTitle: string;
  }
>;
// 后台管理——发货-订单/ 卖家发货
export type sendOrderWareType = InterFunction<
  {
    authPwd?: string;
    imgs?: Array<string>;
    orderInfoId?: number;
    orderRefundId?: number;
    remark?: string;
    renAddress?: string;
    renName?: string;
    renPhone?: string;
    sendAddress?: string;
    sendExCode?: string;
    sendExNo?: string;
    vcuSatus?: number;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// 订单状态-字典
export type listTranStatusType = InterFunction<
  NonNullable<unknown>,
  {
    status: string;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
  }[]
>;
// v1.0.1 物流公司列表-字典
export type listExpressInfoType = InterFunction<
  NonNullable<unknown>,
  {
    exName: string;
    exCode: string;
  }[]
>;
// web/小程序 确认收货-订单
export type renterTakeOrderType = InterFunction<
  {
    authPwd: string;
    imgs: Array<string>;
    orderInfoId: number;
    orderRefundId: number;
    remark: string;
    renAddress: string;
    renName: string;
    renPhone: string;
    sendAddress: string;
    sendExCode: string;
    sendExNo: string;
    vcuSatus: number;
    videoUrl: string;
  },
  NonNullable<unknown>
>;
// 后台管理——平台确认归还
export type pfConfirmOrderWareType = InterFunction<
  {
    authPwd?: string;
    imgs?: Array<string>;
    orderInfoId?: number;
    orderRefundId?: number;
    remark?: string;
    renAddress?: string;
    renName?: string;
    renPhone?: string;
    sendAddress?: string;
    sendExCode?: string;
    sendExNo?: string;
    vcuSatus?: number;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// web-小程序——订单详情相关图片信息
export type orderImageDetailType = InterFunction<
  { orderInfoId: number },
  {
    id: number;
    orderInfoId: number;
    vcuType: number;
    vcuSatus: number;
    remark: string;
    imgs: Array<string>;
    videoUrl: string;
  }[]
>;
// 后台管理关闭订单
export type platFormCloseOrderType = InterFunction<
  { orderInfoId: number; shutReason: string },
  NonNullable<unknown>
>;
// 后台管理——驳回/同意退款
export type refundOrderType = InterFunction<
  {
    orderInfoId: number;
    refund: boolean;
  },
  NonNullable<unknown>
>;
//服务-订单
export type serviceOrderType = InterItemFunction<
  { startTime?: string; endTime?: string; orderStatus?: number; orderNameOrNo?: string },
  {
    id: number;
    orderName: string;
    orderNo: string;
    orderStatus: number;
    coverPlan: string;
    orderAmt: number;
    phoneNum: string;
    uid: string;
    createdTime: string;
    userName: string;
    nickName: string;
  }[]
>;
// 服务-订单字典
export type serviceOrderStatusType = InterFunction<
  any,
  { flyerPort: string; orderStatus: number; managePort: string; userPort: string }[]
>;
// 商城订单-订单状态-字典
export type orderListStatus = InterFunction<
  NonNullable<unknown>,
  {
    code: number;
    nextCode: number;
    status: string;
  }[]
>;
// v1.0.0订单管理-分页查询（改版后）
export type listPageManagerVerOne = InterListFunction<
  {
    endTime?: string;
    keyword?: string;
    keyword2?: string;
    saleId?: number;
    showType?: number;
    signStatus?: Array<number>;
    startTime?: string;
    statusCode?: Array<number>;
  },
  {
    contractNo: string;
    contractSignedWay: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    entName: string;
    id: number;
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    mremark: string;
    ogSkuSpecDTOList: null;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderMainImg: string;
    orderName: string;
    orderNo: string;
    payMethod: number;
    phoneNum: string;
    realNameAuth: number;
    realPayAmount: number;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    saleId: number;
    saleName: string;
    shareId: number;
    shareStatus: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    subAmount: number;
    tagName: string;
    totalBuyNum: number;
    uid: string;
    userAccountId: number;
    userName: string;
  }
>;
// v1.0.0订单管理-详情（改版后）
export type getMallOrderDetailById = InterFunction<
  {
    orderId: number;
  },
  {
    archiveDate: string;
    companyName: string;
    contractNo: string;
    contractSignedWay: number;
    cooperationTagId: number;
    couponDiscountAmount: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    exp: {
      orderId: number;
      sendExpCode: string;
      sendExpNo: string;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
    };
    goodsNum: number;
    id: number;
    kdn: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    manualDiscountAmount: number;
    mremark: string;
    nickName: string;
    ogSkuSpecDTOList: Array<{
      id: number;
      directoryId: number;
      shopCarId: null;
      skuSpecName: string;
    }>;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderCouponDTOS: Array<{
      couponName: string;
      couponType: number;
      couponUserId: number;
      createTime: string;
      id: number;
      orderId: number;
      useAmount: number;
      useType: number;
    }>;
    orderName: string;
    orderNo: string;
    payErrInfo: string;
    payMethod: number;
    phoneNum: string;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    serviceNames: Array<string>;
    shareId: number;
    shareStatus: number;
    shopCarAmount: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    tagName: string;
    uid: string;
    userAccountId: number;
    userAddress: {
      id: number;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
      type: number;
    };
    userAddressId: number;
    userName: string;
  }
>;

// 需求订单-列表
export type serviceOrderFormListType = InterItemFunction<
  {
    orderAttribute?: number;
    /**
     * 抢单手机号
     */
    preemptPhone?: string;
    /**
     * 发单手机号
     */
    publishPhone?: string;
  },
  {
    /**
     * 订单当前状态
     */
    doing?: string;
    /**
     * id
     */
    id?: number;
    /**
     * 1正常 2争议订单
     */
    orderAttribute?: number;
    /**
     * 平台总收益
     */
    orderEarnings?: number;
    /**
     * 订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER
     */
    orderLevel?: string;
    /**
     * 抢单者电话
     */
    preemptPhone?: string;
    /**
     * 发布者订单编号
     */
    publisherNumber?: string;
    /**
     * 发布者电话
     */
    publishPhone?: string;
    /**
     * 服务类型id
     */
    serviceId?: number;
    /**
     * 服务类型名称
     */
    serviceName?: string;
    waiting: string;
  }[]
>;
// 需求订单-详情
export type serviceOrderFormDetailsType = InterFunction<
  { requirementsInfoId: number },
  {
    cashAmount: number;
    createTime: string;
    id: number;
    latitude: number;
    longitude: number;
    orderAmount: number;
    orderEarnings: number;
    orderEarningsDTO: null;
    preemptCashAmount: number;
    preemptSalaryAmount: number;
    preemptWeChat: number;
    publisherNumber: string;
    requireDescription: string;
    salaryAmount: number;
    serviceId: number;
    serviceName: string;
    taskAddress: string;
    taskEndTime: string;
    taskStartTime: string;
    updateOrderAmount: number;
    weChat: number;
    orderStatus: string;
  }
>;
// 需求订单-进度条
export type flowDictionaryType = InterFunction<
  any,
  {
    /**
     * 当前状态
     */
    doing: string;
    /**
     * 飞手当前状态
     */
    flyerPort: string;
    id: number;
    /**
     * 状态码
     */
    orderStatus: string;
    /**
     * 用户当前流程状态
     */
    userPort: string;
    /**
     * 等待状态
     */
    waiting: string;
  }[]
>;
// 需求订单-进度条(带时间)
type flowDictionaryDTO = {
  /**
   * 当前状态
   */
  doing?: string;
  /**
   * 飞手当前状态
   */
  flyerPort?: string;
  id?: number;
  /**
   * 状态码
   */
  orderStatus?: string;
  /**
   * 用户当前流程状态
   */
  userPort?: string;
  /**
   * 等待状态
   */
  waiting?: string;
};
export type flowDictionaryAndTimeType = InterFunction<
  { requirementsInfoId: number },
  {
    amountUpdate?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * 服务需求id
       */
      requirementsInfoId: number;
      updateTime?: Date;
    };
    requirementsServiceDTO?: {
      /**
       * 抢单时间
       */
      createTime?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * 服务id
       */
      requirementsInfoId?: number;
      /**
       * 抢单时间
       */
      updateTime?: string;
    };
    serviceArriveSceneDTO?: {
      /**
       * 到达现场时间
       */
      createTime?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * id
       */
      id?: number;
      /**
       * id
       */
      latitude?: number;
      /**
       * id
       */
      longitude?: number;
      /**
       * 服务需求id
       */
      requirementsInfoId: number;
      /**
       * 现场地址
       */
      sceneAddress?: string;
      /**
       * 现场地址的url
       */
      sceneUrl: string;
      updateTime?: string;
    };
    serviceEvaluateDTO?: {
      createTime?: Date;
      /**
       * 评价内容
       */
      evaluationContent?: string;
      /**
       * 评价图片
       */
      evaluationUrl?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * id
       */
      id?: number;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      /**
       * 星级
       */
      starLevel?: string;
      updateTime?: Date;
    };
    serviceFulfilATaskDTO?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      id?: number;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      /**
       * 完成任务描述
       */
      taskDescribe?: string;
      /**
       * 完成任务图片
       */
      taskUrl?: string;
      updateTime?: Date;
    };
    serviceSettleAccountsDTO?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      id?: number;
      /**
       * 订单金额
       */
      orderAmount?: number;
      /**
       * 备注
       */
      remark?: string;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      updateTime?: Date;
    };
  }
>;
