import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// web 租赁订单-分页-列表
export type listOfRentalOrdersType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// 后台管理 租赁订单-分页-列表
export type listPcWechatOrderType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// web/小程序——订单详情
export type orderDetailType = InterFunction<
  { orderNo: string },
  {
    actualPay: number;
    balance: number;
    buyerName: string;
    buyerPhone: string;
    couponId: number;
    createTime: string;
    deposit: number;
    doing: string;
    endDate: string;
    exWare: number;
    express: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    id: number;
    leaseOrderStatus: string;
    nickName: string;
    orderNo: string;
    orderRefund: {
      actualRefund: number;
      createTime: string;
      id: number;
      orderInfo: {};
      orderInfoId: number;
      orderVcu: {
        id: number;
        imgs: Array<string>;
        orderInfoId: number;
        remark: string;
        vcuSatus: number;
        vcuType: number;
        videoUrl: string;
      };
      pfRemark: string;
      reason: string;
      refundCash: {
        amtPaid: number;
        cashAmt: number;
        createUser: number;
        id: number;
        opName: string;
        opNo: string;
        orderNo: string;
        payMethod: number;
        payNo: string;
        payTime: string;
        refundNo: string;
        remark: string;
        voucher: Array<string>;
        wareTitle: string;
      };
      refundNo: string;
      refundStatus: number;
      rlogs: Array<{
        createTime: string;
        msg: string;
        opAccount: string;
        opName: string;
      }>;
      shouldRefund: number;
    };
    orderType: number;
    payDay: number;
    payNo: string;
    payTime: string;
    pfRemark: string;
    receipt: {
      bookPhone: string;
      detailAddress: string;
      id: number;
      receiptMethod: number;
      region: string;
      renAddress: string;
      renExCode: string;
      renExNo: string;
      renMethod: number;
      renName: string;
      renPhone: string;
      renRepoAddr: string;
      renRepoName: string;
      renRepoPhone: string;
      repoAddress: string;
      repoName: string;
      sendAddress: string;
      sendExCode: string;
      sendExNo: string;
      takeName: string;
      takePhone: string;
    };
    refundExpress: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    remark: string;
    rentPrice: number;
    repoAccountId: number;
    returnTime: string;
    sendWareTime: string;
    shouldPay: number;
    shutReason: string;
    skuInfoId: number;
    skuTitle: string;
    specsId: number;
    startDate: string;
    tranStatus: string;
    uid: string;
    unitPrice: number;
    vcus: Array<{
      id: number;
      imgs: Array<string>;
      orderInfoId: number;
      remark: string;
      vcuSatus: number;
      vcuType: number;
      videoUrl: string;
    }>;
    waiting: string;
    wareDescription: string;
    wareImg: string;
    wareInfoId: number;
    wareNo: string;
    wareNum: number;
    wareTitle: string;
  }
>;
// 后台管理——发货-订单/ 卖家发货
export type sendOrderWareType = InterFunction<
  {
    authPwd: string;
    imgs: Array<string>;
    orderInfoId: number;
    orderRefundId: number;
    remark: string;
    renAddress: string;
    renName: string;
    renPhone: string;
    sendAddress: string;
    sendExCode: string;
    sendExNo: string;
    vcuSatus: number;
    videoUrl: string;
  },
  NonNullable<unknown>
>;
// 订单状态-字典
export type listTranStatusType = InterFunction<
  NonNullable<unknown>,
  {
    status: string;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
  }[]
>;
// v1.0.1 物流公司列表-字典
export type listExpressInfoType = InterFunction<
  NonNullable<unknown>,
  {
    exName: string;
    exCode: string;
  }[]
>;
// web/小程序 确认收货-订单
export type renterTakeOrderType = InterFunction<
  {
    authPwd: string;
    imgs: Array<string>;
    orderInfoId: number;
    orderRefundId: number;
    remark: string;
    renAddress: string;
    renName: string;
    renPhone: string;
    sendAddress: string;
    sendExCode: string;
    sendExNo: string;
    vcuSatus: number;
    videoUrl: string;
  },
  NonNullable<unknown>
>;
// 后台管理——平台确认归还
export type pfConfirmOrderWareType = InterFunction<
  {
    authPwd?: string;
    imgs?: Array<string>;
    orderInfoId?: number;
    orderRefundId?: number;
    remark?: string;
    renAddress?: string;
    renName?: string;
    renPhone?: string;
    sendAddress?: string;
    sendExCode?: string;
    sendExNo?: string;
    vcuSatus?: number;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// web-小程序——订单详情相关图片信息
export type orderImageDetailType = InterFunction<
  { orderInfoId: number },
  {
    id: number;
    orderInfoId: number;
    vcuType: number;
    vcuSatus: number;
    remark: string;
    imgs: Array<string>;
    videoUrl: string;
  }[]
>;
// 后台管理关闭订单
export type platFormCloseOrderType = InterFunction<
  { orderInfoId: number; shutReason: string },
  NonNullable<unknown>
>;
// 后台管理——驳回/同意退款
export type refundOrderType = InterFunction<
  {
    orderInfoId: number;
    refund: boolean;
  },
  NonNullable<unknown>
>;
//服务-订单
export type serviceOrderType = InterItemFunction<
  { startTime?: string; endTime?: string; orderStatus?: number; orderNameOrNo?: string },
  {
    id: number;
    orderName: string;
    orderNo: string;
    orderStatus: number;
    coverPlan: string;
    orderAmt: number;
    phoneNum: string;
    uid: string;
    createdTime: string;
    userName: string;
    nickName: string;
  }[]
>;
// 服务-订单字典
export type serviceOrderStatusType = InterFunction<
  any,
  { flyerPort: string; orderStatus: number; managePort: string; userPort: string }[]
>;
// 商城订单-订单状态-字典
export type orderListStatus = InterFunction<
  NonNullable<unknown>,
  {
    code: number;
    nextCode: number;
    status: string;
  }[]
>;
// v1.0.0订单管理-分页查询（改版后）
export type listPageManagerVerOne = InterListFunction<
  {
    endTime?: string;
    keyword?: string;
    keyword2?: string;
    saleId?: number;
    showType?: number;
    signStatus?: Array<number>;
    startTime?: string;
    statusCode?: Array<number>;
  },
  {
    contractNo: string;
    contractSignedWay: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    entName: string;
    id: number;
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    mremark: string;
    ogSkuSpecDTOList: null;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderMainImg: string;
    orderName: string;
    orderNo: string;
    payMethod: number;
    phoneNum: string;
    realNameAuth: number;
    realPayAmount: number;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    saleId: number;
    saleName: string;
    shareId: number;
    shareStatus: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    subAmount: number;
    tagName: string;
    totalBuyNum: number;
    uid: string;
    userAccountId: number;
    userName: string;
  }
>;
// v1.0.0订单管理-详情（改版后）
export type getMallOrderDetailById = InterFunction<
  {
    orderId: number;
  },
  {
    archiveDate: string;
    companyName: string;
    contractNo: string;
    contractSignedWay: number;
    cooperationTagId: number;
    couponDiscountAmount: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    exp: {
      orderId: number;
      sendExpCode: string;
      sendExpNo: string;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
    };
    goodsNum: number;
    id: number;
    kdn: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    manualDiscountAmount: number;
    mremark: string;
    nickName: string;
    ogSkuSpecDTOList: Array<{
      id: number;
      directoryId: number;
      shopCarId: null;
      skuSpecName: string;
    }>;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderCouponDTOS: Array<{
      couponName: string;
      couponType: number;
      couponUserId: number;
      createTime: string;
      id: number;
      orderId: number;
      useAmount: number;
      useType: number;
    }>;
    orderName: string;
    orderNo: string;
    payErrInfo: string;
    payMethod: number;
    phoneNum: string;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    serviceNames: Array<string>;
    shareId: number;
    shareStatus: number;
    shopCarAmount: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    tagName: string;
    uid: string;
    userAccountId: number;
    userAddress: {
      id: number;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
      type: number;
    };
    userAddressId: number;
    userName: string;
  }
>;
