import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// V1.0.1课程视频列表
export type queryCurriculumInfoListType = InterListFunction<
  {
    curriculumName?: string;
    flightSkillsId?: number;
    categoriesId?: number;
    licenseId?: number;
    regionId?: number;
  },
  {
    curriculumDesc: string;
    curriculumName: string;
    detailContent: null;
    flightSkills: number;
    flightSkillsName1: string;
    flightSkillsName2: string;
    free: number;
    id: number;
    price: null;
    supplierName: string;
    surfaceUrl: null;
    videoUrl: string;
    categoriesId: number;
    directoryName: null;
    categoriesName: null;
  }
>;
// V1.0.1新增课程
export type addCurriculumType = InterFunction<
  {
    categoriesId?: number;
    categoriesName?: string;
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    directoryName?: string;
    flightSkills?: number;
    free?: number;
    id?: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1修改课程
export type updateCurriculumType = InterFunction<
  {
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    flightSkills?: number;
    flightSkillsName1?: string;
    flightSkillsName2?: string;
    free?: number;
    id: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1课程技能列表
export type treeCurriculumSkillType = InterFunction<
  any,
  {
    id: number;
    skillsName: string;
    flightSkills: Array<{
      id: number;
      skillsName: string;
      flightSkills: null;
    }>;
  }[]
>;
// V1.0.1删除课程
export type removeCurriculumType = InterFunction<{ id: number }, NonNullable<unknown>>;
// 根据类型获取各个目录及分类信息
export type queryCategoryInfoByType = InterFunction<
  {
    /**
     * 类型:1：作业服务 2：设备 3：培训 4：产品商城
     */
    type: number;
  },
  {
    directoryId: number;
    name: string;
    categoriesInfoListDTO: Array<{
      id: number;
      directoryId: number;
      name: string;
      icon: string;
      children: {
        id: number;
        directoryId: number;
        name: string;
        icon: string;
      }[];
    }>;
  }[]
>;
//服务-新增
export type addServiceType = InterFunction<
  {
    applicationId: number;
    coverPlan: string;
    displayState: number;
    industryId: number;
    serviceIntroduction?: string;
    serviceName: string;
    shareCard?: string;
    video?: string;
    companyId: number;
  },
  any
>;
//服务-更新
export type editServiceType = InterFunction<
  {
    applicationId?: number;
    coverPlan?: string;
    displayState?: number;
    industryId?: number;
    serviceIntroduction?: string;
    serviceName?: string;
    shareCard?: string;
    video?: string;
    id: number;
    companyId?: number;
  },
  any
>;
//服务-列表
export type serviceType = InterItemFunction<
  { applicationId?: number; industryId?: number; serviceName?: string; displayState?: number },
  {
    applicationName: string;
    serviceName: string;
    industryName: string;
    coverPlan: string;
    shareCard: string;
    video: string;
    serviceIntroduction: string;
    displayState: number;
    applicationId: number;
    industryId: number;
    id: number;
    companyId: number;
    sort: number;
  }[]
>;
//服务-上下架-批量
export type batchUpAndDownWorkServiceType = InterFunction<
  { displayState: number; ids: number[] },
  any
>;
//服务-删除-批量
export type deleteServiceType = InterFunction<number[], any>;
//服务-详情
export type serviceDetailType = InterFunction<
  { id: number },
  {
    applicationName: string;
    serviceName: string;
    industryName: string;
    coverPlan: string;
    shareCard: string;
    video: string;
    serviceIntroduction: string;
    displayState: number;
    applicationId: number;
    industryId: number;
    id: number;
    companyName: string;
  }
>;
//服务-上下移动
export type exChangeServiceType = InterFunction<{ id: number; sort: number }[], any>;
// pc-单位服务列表
export type listCompanyInspectionPageType = InterListFunction<
  {
    companyInfoId?: number;
    industryTypeId?: number;
    inspectionId?: number;
    keyword?: string;
  },
  {
    companyInfoId: number;
    companyName: string;
    detailPage: string;
    id: number;
    industryTypeDTO: {
      createTime: string;
      description: string;
      id: number;
      inspectionDTOS: Array<{
        caseImg: string;
        caseVideo: string;
        companyInspectionDTOS: null;
        id: number;
        industryTypeId: number;
        inspectionDescription: string;
        inspectionImg: string;
        inspectionName: string;
        inspectionNo: string;
        saleState: number;
      }>;
      saleState: number;
      typeImg: string;
      typeName: string;
    };
    inspectionDTO: {
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: null;
      id: number;
      industryTypeId: number;
      inspectionDescription: string;
      inspectionImg: string;
      inspectionName: string;
      inspectionNo: string;
      saleState: number;
    };
    inspectionFileDTOS: Array<{
      companyInspectionId: number;
      fileType: number;
      fileUrl: string;
      first: number;
      id: number;
    }>;
    inspectionFirstImg: string;
    inspectionId: number;
    inspectionPriceUnitId: number;
    inspectionTagDTO: {
      id: number;
      inspectionId: number;
      tagName: string;
    };
    inspectionTagId: number;
    price: number;
    priceRemark: string;
    remark: string;
    saleState: number;
    serviceArea: string;
  }
>;
// 新增服务
export type companyInspectionInsertType = InterFunction<
  {
    companyInfoId?: number;
    companyInspectionFiles?: Array<{
      companyInspectionId?: number;
      fileType?: number;
      fileUrl?: string;
      first?: number;
      id?: number;
    }>;
    detailPage?: string;
    id?: number;
    inspectionId?: number;
    inspectionPriceUnitId?: number;
    inspectionTagId?: number;
    price?: number;
    priceRemark?: string;
    remark?: string;
    saleState?: number;
    serviceArea?: string;
  },
  NonNullable<unknown>
>;
// 修改服务
export type companyInspectionUpdateType = InterFunction<
  {
    companyInfoId?: number;
    companyInspectionFiles?: Array<{
      companyInspectionId?: number;
      fileType?: number;
      fileUrl?: string;
      first?: number;
      id?: number;
    }>;
    detailPage?: string;
    id?: number;
    inspectionId?: number;
    inspectionPriceUnitId?: number;
    inspectionTagId?: number;
    price?: number;
    priceRemark?: string;
    remark?: string;
    saleState?: number;
    serviceArea?: string;
  },
  NonNullable<unknown>
>;
// 单位服务详情
export type getCompanyInspectionByIdType = InterFunction<
  {
    id: number;
  },
  {
    companyInfoId: number;
    companyName: string;
    detailPage: string;
    id: number;
    industryTypeDTO: {
      createTime: string;
      description: string;
      id: number;
      inspectionDTOS: Array<{
        caseImg: string;
        caseVideo: string;
        companyInspectionDTOS: null;
        createTime: string;
        id: number;
        industryTypeId: number;
        inspectionDescription: string;
        inspectionImg: string;
        inspectionName: string;
        inspectionNo: string;
        saleState: number;
      }>;
      saleState: number;
      typeImg: string;
      typeName: string;
    };
    inspectionDTO: {
      caseImg: string;
      caseVideo: string;
      companyInspectionDTOS: null;
      createTime: string;
      id: number;
      industryTypeId: number;
      inspectionDescription: string;
      inspectionImg: string;
      inspectionName: string;
      inspectionNo: string;
      saleState: number;
    };
    inspectionFileDTOS: Array<{
      companyInspectionId: number;
      fileType: number;
      fileUrl: string;
      first: number;
      id: number;
    }>;
    inspectionFirstImg: string;
    inspectionId: number;
    inspectionPriceUnitId: number;
    inspectionTagDTO: {
      id: number;
      inspectionId: number;
      tagName: string;
    };
    inspectionTagId: number;
    price: number;
    priceRemark: string;
    remark: string;
    saleState: number;
    serviceArea: string;
  }
>;
// 价格单位列表
export type listInspectionPriceUnitType = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    unitName: string;
  }[]
>;
// 删除单位服务
export type companyInspectionRemoveType = InterFunction<{ id: number }, NonNullable<unknown>>;
// 合作商家列表-根据合作标签id获取
export type listCompanyInfoByCoopIdType = InterListFunction<
  {
    coopId: number;
    lat: number;
    lon: number;
    pageNo: number;
    pageSize: number;
  },
  {
    address: string;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: number;
    remark: string;
    score: string;
    userAccountId: number;
    backImg: string;
    city: string;
    distance: number;
    district: string;
    province: string;
    backUserAccountId: number;
  }
>;
