import {
  listPublishPageType,
  requirementsListType,
  releaseTenderNews,
  releaseTenderNewsAdd,
  releaseTenderNewsDelete,
  releaseTenderNewsUpdate,
  releaseTenderNewsInfo,
  releaseTenderNewsInfoUpdate,
  releaseTenderNewsApplyList,
  addIndustryNewsType,
  industryNewsListType,
  editIndustryNews,
  industryNewsDetailType,
  industryCaseListCasePage,
  industryCaseAddCase,
  industryCaseUpdateCase,
  industryCaseDeleteDetails,
  deleteIndustryNewsType,
  deleteRequirementsType,
  backDetailPublishType,
} from '~/api/interface/resourceManageType';
import axios from '../request';

export class ResourceManageAPI {
  //需求列表
  static getListPublishPage: listPublishPageType = (data) =>
    axios.post('/release/requirements/listPublishPage', data);
  //  需求类型列表
  static getRequirementTypeList: requirementsListType = () =>
    axios.get('/release/requirements/listType');
  //需求-强制删除
  static deleteRequirement: deleteRequirementsType = (params) =>
    axios.get('/release/requirements/deleteRequire', { params });
  //需求-详情
  static getDetailPublish: backDetailPublishType = (params) =>
    axios.get('/release/requirements/backDetailPublish', { params });

  // 查询招标快讯列表-分页
  static releaseTenderNews: releaseTenderNews = (params) =>
    axios.get('/release/tender/news', { params });

  // 新增招标快讯
  static releaseTenderNewsAdd: releaseTenderNewsAdd = (params) =>
    axios.post('/release/tender/news', params);

  // 修改招标快讯
  static releaseTenderNewsUpdate: releaseTenderNewsUpdate = (params) =>
    axios.put('/release/tender/news', params);

  // 删除招标快讯
  static releaseTenderNewsDelete: releaseTenderNewsDelete = (params) =>
    axios.delete(`/release/tender/news/${params?.id}`);

  // 查询-招标快讯详情列表-分页
  static releaseTenderNewsInfo: releaseTenderNewsInfo = (params) =>
    axios.get('/release/tender/info', { params });

  // 修改-招标快讯详情
  static releaseTenderNewsInfoUpdate: releaseTenderNewsInfoUpdate = (params) =>
    axios.put('/release/tender/info', params);

  // 用户反馈列表-分页
  static releaseTenderNewsApplyList: releaseTenderNewsApplyList = (params) =>
    axios.post('/release/tender/applyList', params);
  //  行业新闻-新增
  static addIndustryNews: addIndustryNewsType = (data) =>
    axios.post('/release/industry-news/insertIndustryNews', data);
  //  行业新闻-列表
  static getIndustryNewsList: industryNewsListType = (data) =>
    axios.post('/release/industry-news/backgroundListNewsPage', data);
  //  行业新闻-编辑
  static editIndustryNews: editIndustryNews = (data) =>
    axios.post('/release/industry-news/upDateIndustryNews', data);
  //  行业新闻-详情
  static getIndustryNewsDetail: industryNewsDetailType = (params) =>
    axios.get('/release/industry-news/details', { params });
  //  行业新闻-删除
  static removeIndustryNews: deleteIndustryNewsType = (params) =>
    axios.get('/release/industry-news/deleteIndustryNews', { params });

  // 案例列表
  static industryCaseListCasePage: industryCaseListCasePage = (params) =>
    axios.post('/release/industry-case/listCasePage', params);

  // 添加业务案例
  static industryCaseAddCase: industryCaseAddCase = (params) =>
    axios.post('/release/industry-case/addCase', params);

  // 修改业务案例
  static industryCaseUpdateCase: industryCaseUpdateCase = (params) =>
    axios.post('/release/industry-case/updateCase', params);

  // 删除业务案例
  static industryCaseDeleteDetails: industryCaseDeleteDetails = (params) =>
    axios.get('/release/industry-case/deleteDetails', { params });
}
