import SearchBox, { searchColumns as searchColumnsType } from '~/components/search-box';
import { Button, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table/InternalTable';
import AddOrEditRentModeModal from '~/pages/rentManage/rentMode/components/addOrEditRentModeModal';
import { useEffect, useState } from 'react';
import { RentManageAPI } from '~/api';
import { PaginationProps } from '~/api/interface';

const RentMode = () => {
  const tableColumns: ColumnsType<any> = [
    {
      title: '型号名称',
      align: 'center',
    },
    {
      title: '所属类型',
      align: 'center',
    },
    {
      title: '所属品牌',
      align: 'center',
    },
    {
      title: '标签',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
    },
  ];

  const searchColumns: searchColumnsType[] = [
    {
      name: '',
      label: '设备类型',
      placeholder: '请选择设备类型',
      type: 'select',
      options: [],
    },
  ];

  const [addOrEditRentModelModalShow, setAddOrEditRentModelModalShow] = useState<boolean>(false);
  const [pagination, setPagination] = useState<PaginationProps & { totalCount: number }>({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
  });

  //新增，编辑型号弹窗
  const addOrEditRentModelClick = () => {
    setAddOrEditRentModelModalShow(true);
  };
  const addOrEditRentModelModalCancel = () => {
    setAddOrEditRentModelModalShow(false);
  };
  const addOrEditRentModelModalOk = () => {
    setAddOrEditRentModelModalShow(true);
  };
  //类型列表
  const getModeList = () => {
    RentManageAPI.getRentModeList({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
    }).then(({ result }) => {
      pagination.totalCount = result.totalCount;
      setPagination({ ...pagination });
    });
  };

  useEffect(() => {
    getModeList();
  }, []);
  return (
    <div className='rent-model'>
      <SearchBox
        search={searchColumns}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={addOrEditRentModelClick}>
            新增型号
          </Button>
        }
      />
      <Table bordered columns={tableColumns} />
      <AddOrEditRentModeModal
        open={addOrEditRentModelModalShow}
        onCancel={addOrEditRentModelModalCancel}
        onOk={addOrEditRentModelModalOk}
      />
    </div>
  );
};
export default RentMode;
