import { Button, Table, Tag } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import AddOrEditRentMakeModal from './components/addOrEditRentMakeModal';
import { useEffect, useState } from 'react';
import { RentManageAPI } from '~/api';
import { InterDataType, PaginationProps } from '~/api/interface';
import { listBrandInfoType } from '~/api/interface/rentManageType';

//品牌列表返回类型
type makeListType = InterDataType<listBrandInfoType>['list'];

const RentMake = () => {
  const tableColumns: ColumnsType<makeListType[0]> = [
    {
      title: '品牌名称',
      align: 'center',
      dataIndex: 'brandName',
    },
    {
      title: '设备型号',
      align: 'center',
      dataIndex: 'modeInfoList',
      render: (text: makeListType[0]['modeInfoList']) =>
        text?.map((v) => <Tag key={v.id}>{v.modeName}</Tag>),
    },
    {
      title: '操作',
      align: 'center',
      width: '15%',
      render: (_: any, record) => (
        <>
          <Button type='link'>绑定型号</Button>
          <Button type='link' onClick={() => addOrEditRentMakeModalClick(record)}>
            编辑
          </Button>
          <Button type='link'>详情</Button>
        </>
      ),
    },
  ];
  const [addOrEditRentMakeModalShow, setAddOrEditRentMakeModalShow] = useState<boolean>(false);
  const [pagination, setPagination] = useState<PaginationProps & { totalCount: number }>({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
  });
  const [tableData, setTableData] = useState<makeListType>([]);
  const [currentRentMakeItem, setCurrentRentMakeItem] = useState<makeListType[0]>();

  //品牌列表
  const getListBrandInfo = () => {
    RentManageAPI.getListBrandInfo({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
    }).then(({ result }) => {
      pagination.totalCount = result.totalCount;
      setPagination({ ...pagination });
      setTableData(result.list || []);
    });
  };
  //品牌新增，编辑弹窗
  const addOrEditRentMakeModalClick = (record?: makeListType[0]) => {
    setCurrentRentMakeItem(record ? { ...record } : undefined);
    setAddOrEditRentMakeModalShow(true);
  };
  const addOrEditRentMakeModalCancel = () => {
    setAddOrEditRentMakeModalShow(false);
  };
  const addOrEditRentMakeModalOk = () => {
    getListBrandInfo();
    setAddOrEditRentMakeModalShow(false);
  };
  //分页
  const paginationChange = (pageNo: number, pageSize: number) => {
    pagination.pageNo = pageNo;
    pagination.pageSize = pageSize;
    getListBrandInfo();
  };

  useEffect(() => {
    getListBrandInfo();
  }, []);

  return (
    <div className='rent-make'>
      <div className='rent-make-operate' style={{ marginBottom: '10px' }}>
        <Button
          icon={<PlusOutlined />}
          type='primary'
          onClick={() => addOrEditRentMakeModalClick()}
        >
          新增品牌
        </Button>
      </div>
      <Table
        columns={tableColumns}
        bordered
        dataSource={tableData}
        pagination={{
          total: pagination.totalCount,
          pageSize: pagination.pageSize,
          current: pagination.pageNo,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
        rowKey='id'
      />
      <AddOrEditRentMakeModal
        open={addOrEditRentMakeModalShow}
        onCancel={addOrEditRentMakeModalCancel}
        onOk={addOrEditRentMakeModalOk}
        currentRentMakeItem={currentRentMakeItem}
      />
    </div>
  );
};
export default RentMake;
