import { FC, useEffect, useState } from 'react';
import { Form, Modal, Select } from 'antd';
// import { tagLevelEntity } from "@/api/modules/user";
// import { UserAPI } from "@/api";

interface PropsType {
  visible: boolean;
  closed: any;
  data: any;
  state: any;
}

// 修改等级标签
interface tagLevelForm {
  channelLevelId: number;
  mallOperator: number;
  mallSaleManager: number;
}

export const ChangeModal: FC<PropsType> = (props) => {
  // 父组件传参
  const { visible, closed, data, state } = props;
  // 个人等级标签
  const [tagLevelForm] = Form.useForm<tagLevelForm>();
  // 相关运营列表
  const [operationList] = useState([]);
  // 关闭事件
  const handleClosed = () => {
    tagLevelForm.resetFields();
    closed();
  };
  // 提交数据
  const handleSubmit = () => {
    tagLevelForm.validateFields().then(async (value: tagLevelForm) => {
      // 提交表单数据
      const SubmitFuc = async () => {
        // const res: any = await UserAPI.mallUserChangeInfo({
        //   ...value,
        //   userAccountId: data.id,
        // });
        // if (res.code === '200') {
        //   message.success('修改成功');
        //   handleClosed();
        // } else {
        //   message.warning(res.message);
        // }
      };
      // 如果之前填过等级标签，现在又删除了的话，调用删除等级标签的接口
      if (data.channelClass && !value.channelLevelId) {
        // 删除等级标签
        // const res: any = await UserAPI.mallUserDeleteInfo({
        //   userAccountId: data.id,
        // });
        // if (res && res.code === '200') {
        //   await SubmitFuc();
        // } else {
        //   message.warning(res.message);
        // }
      } else {
        await SubmitFuc();
      }
    });
  };
  // 获取运营人员列表
  const getListOperate = () => {
    // UserAPI.getKbtUserList({ keyword: '' }).then(({ result }) => {
    //   if (result) {
    //     setOperationList(
    //       result.map((i: any) => {
    //         return {
    //           label: `${i.userName || i.nickName}(${i.uid})`,
    //           value: i.id,
    //         };
    //       }),
    //     );
    //   }
    // });
  };
  // 组件启动
  useEffect(() => {
    if (data) {
      getListOperate();
      tagLevelForm.setFieldsValue({
        channelLevelId: data.channelClass || undefined,
        mallOperator: data.mallOperator || undefined,
        mallSaleManager: data.mallSaleManager || undefined,
      });
    }
  }, [data]);
  return (
    <Modal open={visible} title='变更' onCancel={handleClosed} destroyOnClose onOk={handleSubmit}>
      <Form form={tagLevelForm} labelCol={{ span: 5 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='等级标签' name='channelLevelId'>
          <Select
            placeholder='请选择等级标签'
            disabled={!data?.realAuthStatus && !data?.entAuthStatus}
            allowClear
          >
            {state.levelTags.map((item: any, index: number) => (
              <Select.Option value={item.id} key={index}>
                {item.tagName}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item label='相关运营' name='mallOperator'>
          <Select placeholder='请选择相关运营' allowClear>
            {operationList.map((item: any, index: number) => (
              <Select.Option value={item.value} key={index}>
                {item.label}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item label='相关销售' name='mallSaleManager'>
          <Select placeholder='请选择相关销售' allowClear>
            {operationList.map((item: any, index: number) => (
              <Select.Option value={item.value} key={index}>
                {item.label}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
