import { InterListType, InterReqType } from '~/api/interface';
import { listPcWechatOrderType, refundOrderType } from '~/api/interface/orderManageType';
import React from 'react';
import { Form, message, Modal, Radio } from 'antd';
import { OrderManageAPI } from '~/api';

// 表格数据类型
type TableType = InterListType<listPcWechatOrderType>;
// 请求数据的类型
type ReqType = InterReqType<refundOrderType>;

// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const OrderRefund: React.FC<propType> = (props) => {
  OrderRefund.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  // 表单钩子
  const [form] = Form.useForm<ReqType>();
  // 关闭弹窗
  const handleCancel = () => {
    form.resetFields();
    closed();
  };
  // 确认事件
  const handleOk = () => {
    form
      .validateFields()
      .then(async (values) => {
        // console.log('确认事件 --->', values);
        await handleSubmit(values);
      })
      .catch((err) => {
        message
          .warning({
            content: err.errorFields[0].errors[0],
          })
          .then();
      });
  };
  // 提交事件
  const handleSubmit = async (values: ReqType) => {
    const res = await OrderManageAPI.refundOrder({
      ...values,
      orderInfoId: Number(data?.id),
    });
    if (res && res.code === '200') {
      message.success('操作成功');
      handleCancel();
    }
  };
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      onOk={handleOk}
      destroyOnClose
      width={400}
    >
      <Form
        name='addForm'
        form={form}
        labelAlign='right'
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 12 }}
      >
        <Form.Item
          label='是否同意'
          name='refund'
          rules={[{ required: true, message: '请选择是否同意' }]}
        >
          <Radio.Group
            options={[
              { label: '同意退款', value: true },
              { label: '拒绝退款', value: false },
            ]}
          />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default OrderRefund;
