import { FC } from 'react';
import { Cascader, Form, Input, Modal, ModalProps, Select } from 'antd';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
}
const ShipmentsOrder: FC<ModalProps & selfProps> = ({ onOk, onCancel, open }) => {
  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };
  return (
    <Modal open={open} title='发货' onOk={handleOk} onCancel={handleCancel}>
      <Form
        name='basic'
        labelCol={{ span: 4 }}
        wrapperCol={{ span: 16 }}
        initialValues={{ remember: true }}
        autoComplete='off'
      >
        <Form.Item
          label='物流公司'
          name='sendExpCode'
          rules={[
            {
              required: true,
              message: '请选择物流公司',
            },
          ]}
        >
          <Select placeholder='请选择物流公司' allowClear></Select>
        </Form.Item>
        <Form.Item
          label='物流编号'
          name='sendExpNo'
          rules={[
            {
              required: true,
              message: '请输入物流编号',
            },
          ]}
        >
          <Input placeholder='请输入物流编号' allowClear />
        </Form.Item>
        <Form.Item
          label='用户姓名'
          name='takeName'
          // rules={[
          //   {
          //     validator: validateUserName,
          //     required: true,
          //   },
          // ]}
        >
          <Input placeholder='请输入用户姓名' allowClear />
        </Form.Item>
        <Form.Item
          label='手机号'
          name='takePhone'
          // rules={[
          //   {
          //     validator: validatePhone,
          //     required: true,
          //   },
          // ]}
        >
          <Input placeholder='请输入手机号' allowClear />
        </Form.Item>
        <Form.Item
          label='收货地址'
          name='takeRegion'
          rules={[
            {
              required: false,
              message: '请选择收货地址',
            },
          ]}
        >
          <Cascader
            // options={location}
            placeholder='请选择收货地址'
            allowClear
            fieldNames={{
              label: 'name',
              value: 'name',
              children: 'childInfo',
            }}
          />
        </Form.Item>
        <Form.Item
          label='详细地址'
          name='takeAddress'
          rules={[
            {
              required: false,
              message: '请输入收货地址',
            },
          ]}
        >
          <Input.TextArea maxLength={70} showCount placeholder='请输入收货地址' allowClear />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default ShipmentsOrder;
