import { Button, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import { FC } from 'react';

interface selfProps {
  addOrEditSkuClick: () => void;
}

const SkuInfo: FC<selfProps> = ({ addOrEditSkuClick }) => {
  const TableColumns: ColumnsType<any> = [
    {
      title: '序号',
      align: 'center',
    },
    {
      title: '规格名称',
      align: 'center',
    },
    {
      title: '选择方式',
      align: 'center',
    },
    {
      title: '是否必选',
      align: 'center',
    },
    {
      title: '规格单位',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
    },
  ];
  return (
    <div className='sku-info'>
      <div className='sku-info-operate' style={{ margin: ' 20px 0 ' }}>
        <Button
          type='primary'
          icon={<PlusOutlined></PlusOutlined>}
          onClick={() => addOrEditSkuClick()}
        >
          添加规格
        </Button>
      </div>
      <Table bordered columns={TableColumns} />
    </div>
  );
};
export default SkuInfo;
