import { Button, Cascader, Form, Input, Radio, Select } from 'antd';
import { Uploader } from '~/components/uploader';
import { UploadOutlined } from '@ant-design/icons';

const BaseInfo = () => {
  const [baseInfoForm] = Form.useForm();
  return (
    <div className='base-info'>
      <Form labelCol={{ span: 1 }} wrapperCol={{ span: 8 }} form={baseInfoForm}>
        <Form.Item label='商品名称'>
          <Input placeholder='请输入商品名称' />
        </Form.Item>
        <Form.Item label='商品描述'>
          <Input.TextArea rows={4} placeholder='请输入商品描述' />
        </Form.Item>
        <Form.Item label='商品主图'>
          <Uploader fileUpload listType='picture-card'>
            <UploadOutlined />
          </Uploader>
        </Form.Item>
        <Form.Item label='商品副图'>
          <Uploader fileUpload listType='picture-card'>
            <UploadOutlined />
          </Uploader>
        </Form.Item>{' '}
        <Form.Item label='商品视频'>
          <Uploader fileUpload listType='text'>
            <Button icon={<UploadOutlined />}>上传视频</Button>
          </Uploader>
        </Form.Item>
        <Form.Item label='商品分类'>
          <Cascader placeholder='请选择商品分类' />
        </Form.Item>
        <Form.Item label='商品状态'>
          <Select placeholder='请选择商品状态'>
            <Select.Option>上架</Select.Option>
            <Select.Option>下架</Select.Option>
          </Select>
        </Form.Item>
        <Form.Item label='商品标签'>
          <Radio.Group>
            <Radio value={1}>显示</Radio>
            <Radio value={0}>不显示</Radio>
          </Radio.Group>
        </Form.Item>
      </Form>
    </div>
  );
};
export default BaseInfo;
