import { Form, Input, Radio } from 'antd';
import './index.scss';
import { forwardRef, useEffect, useImperativeHandle } from 'react';
import { InterDataType } from '~/api/interface';
import { leaseGoodsDetailsType } from '~/api/interface/rentManageType';
import { qualityList } from '~/utils/dictionary';

//租赁商品详情返回类型
type rentGoodsDetailType = InterDataType<leaseGoodsDetailsType>;
type goodsInfoForm = {
  tradeName: string;
  sellingPoint: string;
  level: number;
  shelfStatus: number;
};
interface selfProps {
  ref: any;
  rentGoodsDetails: rentGoodsDetailType | undefined;
}

const GoodsInfo = forwardRef<any, selfProps>(({ rentGoodsDetails }, ref) => {
  const [form] = Form.useForm<goodsInfoForm>();

  useImperativeHandle(ref, () => ({
    submitGoodsInfoForm,
    getForm: () => form,
  }));

  const submitGoodsInfoForm = () => {
    return new Promise((resolve, reject) => {
      form
        .validateFields()
        .then((value) => {
          resolve(value);
        })
        .catch((error) => {
          console.log('商品信息错误--->', error);
          reject(error);
        });
    });
  };

  useEffect(() => {
    if (rentGoodsDetails) {
      form.setFieldsValue({
        tradeName: rentGoodsDetails.tradeName,
        sellingPoint: rentGoodsDetails.sellingPoint,
        level: rentGoodsDetails.level,
        shelfStatus: rentGoodsDetails.shelfStatus,
      });
    }
  }, [rentGoodsDetails]);

  return (
    <div className='goods-info'>
      <div className='goods-info-title'>商品信息</div>
      <Form
        labelCol={{ span: 2 }}
        wrapperCol={{ span: 10 }}
        initialValues={{ level: 0, shelfStatus: 1 }}
        form={form}
      >
        <Form.Item
          label='商品标题'
          name='tradeName'
          rules={[{ required: true, message: '请输入商品标题' }]}
        >
          <Input placeholder='请输入商品标题' maxLength={30} />
        </Form.Item>
        <Form.Item
          label='营销短语'
          name='sellingPoint'
          rules={[{ required: true, message: '请输入商品卖点' }]}
        >
          <Input placeholder='请输入商品卖点' maxLength={30} />
        </Form.Item>
        <Form.Item label='商品成新' name='level'>
          <Radio.Group>
            {qualityList.map((v, index) => (
              <Radio value={v.value} key={index}>
                {v.label}
              </Radio>
            ))}
          </Radio.Group>
        </Form.Item>
        <Form.Item label='商品状态' name='shelfStatus'>
          <Radio.Group>
            <Radio value={1}>上架</Radio>
            <Radio value={0}>下架</Radio>
          </Radio.Group>
        </Form.Item>
      </Form>
    </div>
  );
});
export default GoodsInfo;
