import { useEffect, useState } from 'react';
import { Button, message, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import SearchView from '~/components/search-box/index';
import { PointManageAPI } from '~/api';
import { UserPointListType } from '~/api/interface/pointManageType';
import { useNavigate } from 'react-router-dom';
import { InterListType, InterReqListType } from '~/api/interface';
import qs from 'query-string';

// 列表的类型
type TableType = InterListType<UserPointListType>;
// 搜索表单的类型
type ReqType = InterReqListType<UserPointListType>;
// 搜索表单的数据
let query: ReqType = {};

export const PointList = () => {
  // 路由操作
  const navigate = useNavigate();
  // 金额数据
  // const [pointData, setPointData] = useState<ListType>();
  // 表格数据
  const [tableData, setTableData] = useState<TableType>([]);
  // 表格分页配置
  const [pagination, setPagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 跳转指定明细详情
  // const handleDetailList = (type: number) => {
  //   navigation(`/pointManage/pointList/list?type=${type}`);
  // };
  // +++++++++++++++++++++++++++++++++++++++++++++++++++ //
  // 新版通用部分(ES6+ for React) ZhangLK 2022/08/30 Start
  // 加载列表
  const getTableList = async (value = {}) => {
    // 只需要修改这个地方的接口即可
    const res = await PointManageAPI.UserPointList({
      pageNo: pagination.current,
      pageSize: pagination.pageSize,
      ...value,
      ...query,
    });
    if (res && res.code === '200') {
      const { list, pageNo, totalCount, pageSize, totalPage } = res.result; // 解构
      setPagination({
        total: totalCount,
        current: pageNo,
        pageSize,
        totalPage,
      });
      setTableData(list || []);
      // setPointData(res?.result?.list);
    } else {
      message.warning(res.message);
    }
  };
  // 翻页
  const paginationChange = (pageNo: number, pageSize: number) => {
    getTableList({ pageNo, pageSize }).then();
  };
  // 表单提交
  const onFinish = (data: ReqType) => {
    pagination.current = 1;
    query = data;
    getTableList(data).then();
  };
  // +++++++++++++++++++++++++++++++++++++++++++++++++++ //
  // 跳转详情
  const handleDetail = (record: TableType[0]) => {
    const search = {
      id: record.userAccountId,
      totalPoints: record.totalPoints,
      nickName: record.nickName || '游客用户',
    };
    navigate(`/pointManage/pointList/detail?${qs.stringify(search)}`);
  };
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    { title: 'UID', dataIndex: 'userAccountId', align: 'center' },
    {
      title: '用户名称',
      dataIndex: 'userName',
      align: 'center',
      render: (text, record) => text || record?.nickName || `游客用户`,
    },
    // {
    //   title: '企业名称',
    //   dataIndex: 'entName',
    //   align: 'center',
    //   render: (text: string, record) => text || (record.phoneNum ? '微信用户' : '游客用户'),
    // },
    {
      title: '手机号',
      dataIndex: 'phoneNum',
      align: 'center',
    },
    {
      title: '积分总额',
      dataIndex: 'totalPoints',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: (_text: any, record) => (
        <Button type='link' onClick={() => handleDetail(record)}>
          详情
        </Button>
      ),
    },
  ];
  useEffect(() => {
    query = {};
    (async () => {
      await getTableList();
    })();
  }, []);
  return (
    <>
      <SearchView
        search={[
          {
            label: '微信昵称',
            name: 'nickName',
            type: 'input',
            placeholder: '请输入微信昵称',
            width: 180,
          },
          {
            label: '手机号',
            name: 'phoneNum',
            type: 'input',
            placeholder: '请输入手机号',
          },
          // {
          //   label: '企业名称',
          //   name: 'entName',
          //   type: 'input',
          //   placeholder: '请输入企业名称',
          // },
        ]}
        searchData={onFinish}
        // sufFixBtn={
        //   <div className='point-list-head-number'>
        //     <div className='head-number'>
        //       <span className='number-label'>积分发放总额</span>
        //       <Button type='link' onClick={() => handleDetailList(0)}>
        //         {pointData?.releaseScore}
        //       </Button>
        //     </div>
        //     <div className='head-number'>
        //       <span className='number-label'>积分兑换总额</span>
        //       <Button type='link' onClick={() => handleDetailList(1)}>
        //         {pointData?.convertScore}
        //       </Button>
        //     </div>
        //     <div className='head-number'>
        //       <span className='number-label'>积分提现总额</span>
        //       <Button type='link' onClick={() => handleDetailList(2)}>
        //         {pointData?.withdrawScore}
        //       </Button>
        //     </div>
        //     <div className='head-number'>
        //       <span className='number-label'>待处理提现积分</span>
        //       <Button type='link' onClick={() => handleDetailList(2)}>
        //         {pointData?.withdrawingScore}
        //       </Button>
        //     </div>
        //   </div>
        // }
      />
      <Table
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='mallUserId'
        // scroll={{ x: 1500 }}
        bordered
        pagination={{
          total: pagination.total,
          pageSize: pagination.pageSize,
          current: pagination.current,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
      />
    </>
  );
};
