import { Button, message } from 'antd';
import { useNavigate, useSearchParams } from 'react-router-dom';
import './index.scss';
import { useEffect, useState } from 'react';
import { MallManageAPI } from '~/api';
import RichText from '~/components/richText';
import { InterDataType } from '~/api/interface';
import { serviceDetailType } from '~/api/interface/mallManageType';

//服务详情-返回类型
type detailType = InterDataType<serviceDetailType>;
const ServiceIntroduce = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();
  const [serviceDetail, setServiceDetail] = useState<detailType>();
  const [serviceId, setServiceId] = useState<number>(0);
  const [serviceIntroduction, setServiceIntroduction] = useState<string>('');

  //服务详情
  const getServiceDetail = (id: number) => {
    MallManageAPI.getServiceDetail({ id }).then(({ result }) => {
      setServiceDetail(result);
    });
  };
  const richTextChange = (text?: string) => {
    setServiceIntroduction(text || '');
  };
  //保存服务介绍
  const saveIntroduce = () => {
    MallManageAPI.editService({ id: serviceId, serviceIntroduction }).then(({ code }) => {
      if (code === '200') {
        message.success('修改成功');
      }
    });
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };
  useEffect(() => {
    setServiceId(Number(searchParams.get('id')));
    getServiceDetail(Number(searchParams.get('id')));
  }, []);
  return (
    <div className='service-introduce'>
      <div className='service-introduce-operate'>
        <Button type='primary' onClick={saveIntroduce}>
          保存修改
        </Button>
        <Button type='primary' onClick={backRoute}>
          返回
        </Button>
      </div>
      <div className='service-introduce-title'></div>
      <div className='service-introduce-rich-text'>
        <RichText
          richTextContent={serviceDetail?.serviceIntroduction || ''}
          onChange={richTextChange}
        />
      </div>
    </div>
  );
};
export default ServiceIntroduce;
