import RichText from '~/components/richText';
import { FC } from 'react';

interface selfProps {
  onChange: (html: string) => void;
  introduceInfo: string;
}

const IntroduceInfo: FC<selfProps> = ({ onChange, introduceInfo }) => {
  //富文本修改
  const richTextOnChange = (html?: string) => {
    onChange(html || '');
  };

  return (
    <div className='introduce-info'>
      <RichText richTextContent={introduceInfo} height={400} onChange={richTextOnChange} />
    </div>
  );
};
export default IntroduceInfo;
