import { FC } from 'react';
import { Modal, Descriptions } from 'antd';
import { PropsType } from '~/common/interface/modal';
import { couponDetailItemType } from '~/api/interface/couponManage';

const contentStyle = { width: '100px' };
const DataModal: FC<
  Pick<PropsType, 'isModalVisible' | 'handleCancel'> & {
    couponDetailItem: couponDetailItemType | undefined;
  }
> = ({ isModalVisible, handleCancel, couponDetailItem }) => {
  return (
    <Modal
      open={isModalVisible}
      title='查看详情'
      footer={null}
      onCancel={() => handleCancel()}
      width={650}
    >
      <Descriptions bordered size='small'>
        <Descriptions.Item label='兑换时间' contentStyle={contentStyle}>
          {couponDetailItem?.createTime}
        </Descriptions.Item>
        <Descriptions.Item label='兑换比例' contentStyle={contentStyle}>
          {couponDetailItem?.conversionRatio}
        </Descriptions.Item>
        {(couponDetailItem?.gainType === 'presented' ||
          couponDetailItem?.gainType === 'acquire') && (
          <>
            <Descriptions.Item label='转赠人UID' contentStyle={contentStyle}>
              {couponDetailItem?.transferorUid}
            </Descriptions.Item>
            <Descriptions.Item label='获赠人UID' contentStyle={contentStyle}>
              {couponDetailItem?.receiveUid}
            </Descriptions.Item>
            <Descriptions.Item label='转赠时间' contentStyle={contentStyle}>
              {couponDetailItem?.transferorTime}
            </Descriptions.Item>
            <Descriptions.Item label='获赠时间' contentStyle={contentStyle}>
              {couponDetailItem?.createTime}
            </Descriptions.Item>
          </>
        )}
      </Descriptions>
    </Modal>
  );
};
export default DataModal;
