import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
import { UserInfoType } from '~/api/interface/commonType';
// 账号-列表
export type listBAccountPageType = InterListFunction<
  {
    accountStatus?: number;
    area?: string;
    cityCode?: number;
    districtCode?: number;
    keyword?: string;
    provinceCode?: number;
    rcdCompanyId?: number;
    roleId?: number;
    userIds?: Array<number>;
    userType?: number;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    userImg: string;
    userSex: number;
    email: string;
    source: number;
    accountStatus: number;
    remark: string;
    portType: number;
    createTime: string;
    companyAuthStatus: null;
    cooperationTagId: null;
    companyName: string;
    companyInfoVO: {
      id: number;
      companyType: number;
      companyName: string;
      fullName: string;
      province: string;
      city: string;
      district: string;
      address: string;
      companyUserName: string;
      phoneNum: string;
      remark: string;
    };
    roleInfoDTO: {
      id: number;
      roleName: string;
      roleNo: string;
    };
  }
>;
// 账号-新增
export type insertBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
    companyId: number;
    roleId: number;
  },
  NonNullable<unknown>
>;
// 账号-删除
export type removeBAccountType = InterFunction<
  {
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 账号-修改
export type updateBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-修改密码
export type updatePasswordType = InterFunction<
  {
    accountNo?: string;
    accountStatus?: number;
    alertPwd?: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id?: number;
    passWord?: number;
    phoneNum?: string;
    provinceCode?: number;
    remark?: string;
    userName?: string;
  },
  NonNullable<unknown>
>;
// 单位-列表
export type listCompanyPage = InterListFunction<
  { companyName?: string },
  {
    address: string;
    city: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    district: string;
    fullName: string;
    id: number;
    phoneNum: string;
    province: string;
    remark: string;
    lat: number;
    lon: number;
  }
>;
// 单位-新增
export type listCompanyAdd = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
    lat: number;
    lon: number;
  },
  NonNullable<unknown>
>;
// 单位-修改
export type listCompanyUpdate = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
    lat: number;
    lon: number;
  },
  NonNullable<unknown>
>;
// 单位-地域
export type getSecondDistrictInfo = InterFunction<
  NonNullable<unknown>,
  {
    childInfo: any[];
    id: number;
    name: string;
  }[]
>;
// 单位-删除
export type listCompanyRemove = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
//单位-详情
export type getCompanyInfoByIdType = InterFunction<
  { id: number },
  {
    address: string;
    city: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    district: string;
    fullName: string;
    id: number;
    phoneNum: string;
    province: string;
    remark: string;
    licenseImg: string;
    contractNo?: string;
    attachmentList: any;
    brandLogo: string;
    content: string;
    profileUrl: string;
    backUserId: number;
    cooperationTagId: number;
  }
>;
//单位-成员列表
export type listCompanyMembersType = InterItemFunction<
  { companyInfoId: number },
  {
    accountStatus: number;
    accountType: number;
    companyAuthStatus: number;
    companyName: string;
    cooperationTagVOS: {
      createTime: string;
      id: number;
      tagDescription: string;
      tagImg: string;
      tagName: string;
      tagRequire: string;
    }[];
    createTime: string;
    deleted: number;
    email: string;
    id: number;
    inviteCount: number;
    leader: number;
    nickName: string;
    phoneNum: string;
    portType: number;
    realNameAuthStatus: number;
    remark: string;
    source: number;
    uid: string;
    userImg: string;
    userName: string;
    userRcdVO: {
      createTime: string;
      id: number;
      rcdNickname: string;
      rcdUserId: number;
      rcdUserName: string;
      remark: string;
      userAccountId: number;
    };
    userSex: number;
    serviceAlias: string;
    serviceImg: string;
  }[]
>;
//单位-成员绑定
export type bindingCompanyMemberType = InterFunction<
  { companyInfoId: number; userAccountId: number },
  any
>;
//单位-成员解绑
export type unbindCompanyMemberType = InterFunction<
  { companyInfoId: number; userAccountId: number },
  any
>;
//单位-管理员转让
export type transferLeaderType = InterFunction<
  { companyInfoId: number; fromUserAccountId: number; toUserAccountId: number },
  any
>;

//账号权限-列表
export type listRoleInfoPageType = InterItemFunction<
  { numberOrName?: string },
  {
    id: number;
    roleNo: string;
    userName: string;
    roleName: string;
    remark: string;
    superAdmin: number;
  }[]
>;
//账号权限-新增
export type insertRoleInfoType = InterFunction<{ remark?: string; roleName: string }, any>;
//账号权限-编辑
export type updateRoleInfoType = InterFunction<
  { id?: number; remark?: string; roleName: string },
  any
>;
//账号权限-删除
export type deleteRoleInfoType = InterFunction<{ id: number }, any>;
//账号权限-全部菜单列表
type menType = {
  id: number;
  menuName: string;
  pid: number;
  children: menType[];
};
export type listMenuInfoType = InterFunction<any, menType>;
//账号权限-根据id获取权限
export type listRoleMenuInfoType = InterFunction<{ roleId: number }, any>;
//账号权限-修改角色菜单权限
export type updateRoleMenuInfoType = InterFunction<{ menuInfoIds: number[]; roleId: number }, any>;

//地址管理-列表
export type addressListType = InterFunction<
  any,
  {
    takeAddress: string;
    takeName: string;
    takePhone: string;
    takeRegion: string;
    type: number;
    id: number;
    districtCode: string;
  }[]
>;
//地址管理-添加地址
export type addressInsetType = InterFunction<
  {
    takeAddress: string;
    takeName: string;
    takePhone: string;
    takeRegion: string;
    type: number;
    districtCode: string;
  },
  any
>;
//地址管理-编辑地址
export type editAddressType = InterFunction<
  {
    id?: number;
    takeAddress: string;
    takeName: string;
    takePhone: string;
    takeRegion: string;
    type: number;
    districtCode: string;
  },
  any
>;
//地址管理-删除地址
export type deleteAddressType = InterFunction<{ id: number }, any>;
// 地址管理-根据id查找
export type getUserAddressInfoType = InterFunction<
  { userAddressId: number },
  {
    takeAddress: string;
    takeName: string;
    takePhone: string;
    takeRegion: string;
    type: number;
    districtCode: string;
    id: number;
  }
>;
// 获取角色列表
export type getRolesListType = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    roleName: string;
  }[]
>;
// 根据公司id获取用户id和角色信息
export type listUserAndRoleByCompanyIdType = InterFunction<
  {
    companyInfoId?: number;
  },
  {
    /**
     * 角色id
     */
    roleId: number;
    /**
     * 角色姓名
     */
    roleName: string;
    /**
     * 绑定用户id
     */
    userAccountId: number;
    userAccountVO: UserInfoType;
    serviceAlias: string;
    serviceImg: string;
  }[]
>;
// 用户信息列表
export type selectUserListType = InterFunction<
  { userAccountId?: number },
  {
    nickName: string;
    phoneNum: string;
    unreadCount: number;
    userAccountId: number;
    userImg: string;
    userName: null;
    endMessage: string;
    createTime: string;
    companyInfoVO?: {
      address: string;
      brandLogo: string;
      brandName: string;
      companyName: string;
      companyType: number;
      companyUserName: string;
      content: string;
      creditCode: string;
      fullName: string;
      id: number;
      lat: number;
      leader: number;
      licenseImg: string;
      lon: number;
      phoneNum: string;
      remark: string;
      score: string;
      userAccountId: number;
      province: string;
      city: string;
      backUserId: number;
      companyBindUserId: number;
    };
  }[]
>;
// 用户聊天详细信息
export type selectUserMessageType = InterListFunction<
  {
    receiverUserId: number;
    backUserId?: number;
    sendUserId?: number;
  },
  {
    content: string;
    createTime: string;
    id: number;
    imgUrl: null;
    receiverUserId: number;
    senderUserId: number;
    backUserId: number | null;
  }
>;
// 用户发送消息
export type insertUserMessageType = InterListFunction<
  {
    /**
     * 消息内容
     */
    content?: string;
    /**
     * 发送的图片
     */
    imgUrl?: string;
    /**
     * 接收方用户ID
     */
    receiverUserId: number;
    backUserId?: number;
    sendUserId?: number;
  },
  NonNullable<unknown>
>;
// 用户——系统消息列表
export type systemMessageListByUserType = InterListFunction<
  {
    id?: number;
  },
  {
    content: string;
    createTime: string;
    id: number;
    read: boolean;
    subject: string;
  }
>;
// 修改添加客服别名客服头像
export type updateAliasImgByUidType = InterFunction<
  {
    serviceAlias: string;
    serviceImg: string;
    userAccountId?: number;
  },
  NonNullable<unknown>
>;
