import { Button, Form, Input, Modal, ModalProps, Radio, Select, Table } from 'antd';
import { FC, useState } from 'react';
import EditableCell from '~/components/EditableCell';
import { PlusOutlined } from '@ant-design/icons';

type EditableTableProps = Parameters<typeof Table>[0];
type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

interface selfProps {
  onCancel: () => void;
}

const SkuAddOrEditModal: FC<ModalProps & selfProps> = ({ open, onCancel }) => {
  const [tableData] = useState<any>([{ id: 1 }]);
  const defaultColumns: (ColumnTypes[number] & {
    editable?: boolean;
    dataIndex?: string;
    inputType?: string;
    radioOption?: { name: string; id: number }[];
  })[] = [
    {
      title: '图片',
      align: 'center',
      editable: true,
      dataIndex: '',
      inputType: 'uploader',
    },
    {
      title: '选项名称',
      align: 'center',
      editable: true,
      dataIndex: '',
    },
    {
      title: '料号',
      align: 'center',
      editable: true,
      dataIndex: '',
    },
    {
      title: '销售价',
      align: 'center',
      editable: true,
      dataIndex: '',
    },
    {
      title: '渠道价',
      editable: true,
      align: 'center',
      dataIndex: '',
    },
    {
      title: '库存',
      editable: true,
      align: 'center',
      dataIndex: '',
    },
    {
      title: '是否显示',
      editable: true,
      align: 'center',
      dataIndex: '',
      inputType: 'radio',
      width: '20%',
      radioOption: [
        { id: 1, name: '显示' },
        { id: 0, name: '不显示' },
      ],
    },
    {
      title: '操作',
      align: 'center',
      width: '10%',
      render: () => (
        <>
          <Button type='primary' icon={<PlusOutlined />}></Button>
        </>
      ),
    },
  ];
  const columns = defaultColumns.map((col) => {
    if (!col.editable) {
      return col;
    }
    return {
      ...col,
      onCell: (record: any) => ({
        record,
        dataIndex: col.dataIndex,
        title: col.title,
        editing: col.editable,
        radioOption: col.radioOption,
        inputType: col.inputType,
      }),
    };
  });
  const handleCancel = () => {
    onCancel();
  };

  return (
    <Modal open={open} title='添加规格' width={1000} onCancel={handleCancel}>
      <Form labelCol={{ span: 2 }} wrapperCol={{ span: 22 }}>
        <Form.Item label='规格名称'>
          <Input placeholder='请输入规格名称' />
        </Form.Item>
        <Form.Item label='规格值'>
          <Form component={false}>
            <Table
              rowKey='id'
              columns={columns as ColumnTypes}
              components={{
                body: {
                  cell: EditableCell,
                },
              }}
              bordered
              dataSource={tableData}
            ></Table>
          </Form>
        </Form.Item>
        <Form.Item label='选择方式'>
          <Radio.Group>
            <Radio>单选</Radio>
            <Radio>多选</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item label='是否必选'>
          <Radio.Group>
            <Radio>非必选</Radio>
            <Radio>必选</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item label='规格单位'>
          <Select>
            <Select.Option value={0}>件</Select.Option>
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SkuAddOrEditModal;
