import { useState } from 'react';
import { Table } from 'antd';
import { ColumnsType } from 'antd/es/table';

// 表格数据类型
type TableType = any;

function DetailInformation() {
  // 表格数据
  const [tableData] = useState<TableType>([{ id: 1 }]);
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: '商品',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '单价(元)',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '数量',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '订单状态',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '实收款',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
  ];
  return (
    <div className={'detail-information'}>
      <div className={'detail-title'}>订单明细</div>
      <div className={'detail-text'}>
        <span className={'item'}>订单编号：UD202302181041156087</span>
        <span className={'item'}>创建时间：2023-02-18 10:41:16</span>
        <span className={'item'} style={{ display: 'none' }}>
          合同编号：UAV202334741131
        </span>
      </div>
      <Table
        style={{ margin: '20px auto', width: '90%' }}
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        bordered
        pagination={false}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
    </div>
  );
}

export default DetailInformation;
