import axios from '../request';
import {
  MakeListType,
  productListType,
  ProductSpecListType,
} from '~/api/interface/produceManageType';

export class ProduceManageAPI {
  // 产品管理-分页列表
  static listPageProductSku: productListType = (data) => {
    return axios.post('/pms/product/spec/listPageProductSku', data);
  };
  // 产品sku管理-删除产品sku
  static removeProductSku = (params: unknown) => {
    return axios.get('uavgoods/product/spec/removeProductSku', { params });
  };
  static directoryList = () => {
    return axios.get('uavgoods/directory/directoryList');
  };
  // 分类列表(属于商品)
  static getListGoodsTypeList = (type: number): any => {
    return axios.get(`uavgoods/mgoods/getGoodsTypeInfoList/${type}`);
  };
  // 品牌-列表
  static getListBrandInfo: MakeListType = (params) => {
    return axios.get('uavgoods/brand/listBrandInfo', { params });
  };
  // 产品sku管理-新增产品sku
  static addProductSku = (data: unknown) => {
    return axios.post('uavgoods/product/spec/addProductSku', data);
  };

  // 产品sku管理-编辑产品sku
  static editProductSku = (data: unknown) => {
    return axios.post('uavgoods/product/spec/editProductSku', data);
  };
  // 产品规格管理---删除规格
  static removeProductSpec = (params: unknown) => {
    return axios.get('uavgoods/product/spec/removeProductSpec', { params });
  };

  // 产品sku管理-编辑单个产品sku时的信息回显
  static getProductSkuDetail = (params: unknown) => {
    return axios.get('uavgoods/product/spec/getProductSkuDetail', { params });
  };

  // 产品sku管理-产品规格管理-分页列表
  static listPageProductSpec: ProductSpecListType = (params) => {
    return axios.get('/pms/product/spec/listPageProductSpec', { params });
  };
}
