import axios from '../request';
import {
  listExpressInfoType,
  listOfRentalOrdersType,
  listPcWechatOrderType,
  listTranStatusType,
  orderDetailType,
  sendOrderWareType,
} from '~/api/interface/orderManageType';

export class OrderManageAPI {
  // web 租赁订单-分页-列表
  static listOfRentalOrders: listOfRentalOrdersType = (params) =>
    axios.post('/oms/RentalOrders/listOfRentalOrders', params);

  // 后台管理 租赁订单-分页-列表
  static listPcWechatOrder: listPcWechatOrderType = (params) =>
    axios.post('/oms/RentalOrders/listPcWechatOrder', params);

  // web/小程序——订单详情
  static orderDetail: orderDetailType = (params) =>
    axios.get('/oms/RentalOrders/orderDetail', { params });

  // 订单状态-字典
  static listTranStatus: listTranStatusType = (params) =>
    axios.get('/oms/RentalOrders/listTranStatus', { params });

  // 后台管理——发货-订单/ 卖家发货
  static sendOrderWare: sendOrderWareType = (params) =>
    axios.post('/oms/RentalOrders/sendOrderWare', params);

  // v1.0.1 物流公司列表-字典
  static listExpressInfo: listExpressInfoType = (params) =>
    axios.get('/oms/express/listExpressInfo', { params });
}
