import axios from '../request';
import { PaginationEntity } from '~/common/interface/PaginationEntity';
import { categoryListType, directoryListType } from '~/api/interface/categoryManage';

export class CategoryManageAPI {
  // 分类目录
  static getDirectoryList: directoryListType = (params) => {
    return axios.get('/pms/classify/getDirectoryList', { params });
  };

  // 新增或编辑目录
  static addOrEditDirectory = (data: { id?: number; directoryName: string }[]) => {
    return axios.post('uavgoods/directory/addOrEditDirectory', data);
  };

  // 删除目录
  static removeDirectory = (id: number) => {
    return axios.get('uavgoods/directory/removeDirectory', { params: { id } });
  };

  // 分类新增
  static addClassification = (data: object): any => {
    return axios.post('uavgoods/mgoods/addClassification', data);
  };

  // 分类列表
  static getCategoryList: categoryListType = (data) => {
    return axios.post('/pms/classify/getClassificationList', data);
  };

  // PC端-根据分类信息新增自定义规格-下拉选项 （只查产品类型）
  static getProductTypeInfoList = (): any => {
    return axios.get('uavgoods/mgoods/getGoodsTypeInfoList');
  };

  // 所有分类信息
  static getGoodsTypeListByOneLevel = (): any => {
    return axios.get('uavgoods/mgoods/listGoodsTypeListByOneLevel');
  };

  // 分类修改
  static updateClassification = (data: object): any => {
    return axios.post('uavgoods/mgoods/updateClassification', data);
  };

  // 删除分类
  static deleteGoodsTypeByOneLevel = (params: object): any => {
    return axios.get('uavgoods/mgoods/deleteGoodsTypeByOneLevel', { params });
  };

  // 删除子分类
  static deleteGoodsTypeByChildren = (params: object): any => {
    return axios.get('uavgoods/mgoods/deleteGoodsTypeByChildren', { params });
  };

  // 查询二级分类
  static listGoodsTypeListByTwoLevel = (params: object): any => {
    return axios.get('uavgoods/mgoods/listGoodsTypeListByTwoLevel', { params });
  };

  // 查询其它服务
  static listOtherService = (): any => {
    return axios.get('uavgoods/mgoods/listOtherService');
  };

  // 分类上下移动
  static exchangeSortType = (params: object): any => {
    return axios.get('uavgoods/mgoods/exchangeSortType', { params });
  };

  // 分类详情
  static getGoodsTypeDetail = (
    obj: { id: number } & Pick<PaginationEntity, 'pageNo' | 'pageSize'>,
  ) => {
    return axios.get('uavgoods/mgoods/getGoodsTypeDetail', { params: obj });
  };

  // 分类详情-安全编码开发修改
  static updateIsShowCode = (params: Pick<GoodsInfo, 'goodsId' | 'showCode'>) => {
    return axios.get('uavgoods/appgoods/updateIsShowCode', { params });
  };

  // 分类详情-商品排序
  static exchangeGoodsInfo = (firstId: number, secondId: number) => {
    return axios.get('uavgoods/mgoods/exchangeGoodsInfo', {
      params: { firstId, secondId },
    });
  };

  // 分类详情-图片上传
  static cateGoryDetailUpload = (data: FormData) => {
    return axios.post('ossservlet/upload/imgOss', data);
  };
  // 行业分享码
  static getAppletQRCode(params: { page: string; scene: string }) {
    return axios.get('malluser/wechat/getAppletQRCode', { params });
  }
}
