// 分类详情
import { InterFunction, InterItemFunction } from '~/api/interface';

export interface GoodsInfo {
  goodsId: number;
  goodsImg: string;
  goodsName: string;
  shelfStatus: number;
  showCode: number;
}

// 分类列表
export interface categoryEntity {
  goodsMasterType: string;
  icon: string;
  remark: string;
  desc: string;
  createTime: string;
  goodsMasterTypeId: number | string;
  goodsSlaveTypeDTO: Partial<categoryEntity>[];
  pid: number | string;
  isADD?: boolean;
}

// 分类目录
export interface categoryDec {
  defaultType: number;
  id: number;
  sortName: string;
}

//分类列表类型
type categoryReposeType = {
  id: number;
  classifyName: string;
  icon: string;
  createTime: string;
  children: categoryReposeType[];
  directoryId: number;
  remark: string;
};
export type categoryListType = InterItemFunction<
  { directoryId?: number; type?: number },
  categoryReposeType[]
>;
//目录列表类型-不分页
export type directoryListType = InterFunction<
  { type: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
