import { FC, useEffect, useState } from 'react';
import { Form, Modal, Select } from 'antd';
import { InterListType, InterReqType } from '~/api/interface';
import { changeUserTagNew, listAppUserType } from '~/api/interface/customManageType';
import { CustomManageAPI } from '~/api';

// 表单参数
type ReqType = InterReqType<changeUserTagNew>;
// 表格数据类型
type TableType = InterListType<listAppUserType>;
// 数据的类型
interface PropsType {
  open: boolean;
  closed: any;
  data?: TableType[0];
}

export const ChangeModal: FC<PropsType> = (props) => {
  ChangeModal.defaultProps = {
    data: undefined,
  };
  // 父组件传参
  const { open, closed, data } = props;
  // 个人等级标签
  const [form] = Form.useForm<ReqType>();
  // 相关运营列表
  const [operationList] = useState<{ value: number; label: string }[]>([]);
  // 等级标签列表
  const [cooperationTagIdList, setCooperationTagIdList] = useState<
    { value: number; label: string }[]
  >([]);
  // 关闭事件
  const handleClosed = () => {
    form.resetFields();
    closed();
  };
  // 提交数据
  const handleSubmit = () => {
    form.validateFields().then(async (value) => {
      const res = await CustomManageAPI.changeUserTagNew({
        userAccountId: Number(data?.id),
        cooperationTagIds: value?.cooperationTagIds || [],
      });
      if (res && res.code === '200') {
        handleClosed();
      }
    });
  };
  // 获取加盟列表
  const getCompanyListTag = async () => {
    const res = await CustomManageAPI.CompanyListTag({});
    if (res && res.code === '200') {
      setCooperationTagIdList(res.result.map((i) => ({ value: i.id, label: i.tagName })));
      // console.log(res.result);
    }
  };
  // 组件启动
  useEffect(() => {
    if (!data) return;
    getCompanyListTag().then();
    form.setFieldsValue({
      cooperationTagIds: data.cooperationTagVOS?.map((i) => i.id),
    });
  }, [open]);
  return (
    <Modal open={open} title='变更' onCancel={handleClosed} destroyOnClose onOk={handleSubmit}>
      <Form form={form} labelCol={{ span: 5 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='等级标签' name='cooperationTagIds'>
          <Select
            placeholder='请选择等级标签'
            disabled={!data?.userName && !data?.companyName}
            allowClear
            options={cooperationTagIdList}
            mode='multiple'
          />
        </Form.Item>
        <Form.Item label='相关运营' name='mallOperator'>
          <Select placeholder='请选择相关运营' allowClear disabled>
            {operationList.map((item: any, index: number) => (
              <Select.Option value={item.value} key={index}>
                {item.label}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item label='相关销售' name='mallSaleManager'>
          <Select placeholder='请选择相关销售' allowClear disabled>
            {operationList.map((item: any, index: number) => (
              <Select.Option value={item.value} key={index}>
                {item.label}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
